/*
# Copyright (C) 2008-2009 
# Raffaele Granito <raffaele.granito@tiscali.it>
#
# This file is part of myTCPClient:
# Universal TCP Client
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

 
#define __NONE__    0
#define __INFO__    1
#define __WARN__    2
#define __ERR__     3
 

/*
.--------------------------------------------------------------------------------------------.
|                                                                                            |
|                                                                                            |
|                                                                                            |
|                                                                                            |
|                                  PARAM Messages Table                                      |
|                                                                                            |
|                                                                                            |
|                                                                                            |
|                                                                                            |
'--------------------------------------------------------------------------------------------' */
char *PARAM_TABMSG[][3] = {

                     /*
                     .---------------------------------.
                     |                                 |
                     |              Banner             |
                     |                                 |
                     '---------------------------------' */
                     { "MY_CLIENT_TCP__BANNER",
                       "__INFO__",
                       "Universal Client TCP version 0.0.5\n\0"
                       "Raffaele Granito (c) 2008-2009 Licence GPLv2\n\0" }, 

                     /*
                     .---------------------------------.
                     |                                 |
                     |              Formato            |
                     |                                 |
                     '---------------------------------' */
                     { "MY_CLIENT_TCP__FORMATO",
                       "__INFO__",
                       "\nformato: myClientTCP [-c |--connect] protocol://host:port/path/resource?queryString"
                       "\n                     [-U |--auth-user <user>] [-P|--auth-password]"
                       "\n                     [-k |--keystore <filename>] [-p|--password password]"
                       "\n                     [-t |--truststore <filename>"
                       "\n                     [-C |--ciphersuite {cipher1,cipher2,...,cipherN}]" 
                       "\n                     [-s |--ssl-version <version>]" 
                       "\n                     [-T |--type-operation <type>]"
                       "\n                     [-Ml|--message-language <language>]"
                       "\n                     [-Mt|--message-type <type>]"
                       "\n                     [-M |--message <text>]" 
                       "\n                     [-S |--ssl-ciphersuite-server-scan {On|Off}]"
                       "\n                     [-m |--max-request <max-value>]"
                       "\n                     [-o |--output-file <filename>]"
                       "\n                     [-d |--debug {+protocol1+protocol2...+protocolN}]"
                       "\n         myClientTCP [-f |--config <filename>]" 
                       "\n         myClientTCP [-h |--help]"
                       "\n         myClientTCP [-v |--version]\n\n" }, 

                     /*
                     .---------------------------------.
                     |                                 |
                     |             Remarks             |
                     |                                 |
                     '---------------------------------' */
                     { "MY_CLIENT_TCP__REMARKS",
                       "__INFO__",
                       "\nTCP client to measure the degree of security of a connection." },

                     /*
                     .---------------------------------.
                     |                                 |
                     |          Lista Parametri        |
                     |                                 |
                     '---------------------------------' */
                     { "MY_CLIENT_TCP__LISTA_PARAMETRI", 
                       "__INFO__",
                       "\nList of parameters with a small description:"
                       "\n"
                       "\n  -c,--connect          Connection string. The protocol are supported: tcp, ssl  and"
                       "\n                        https, ems, emss. Hostname can be set by specifying  the  IP"
                       "\n                        or the DQFN.                                                "
                       "\n  -U,--auth-user [user-id] -P,--auth-password [password]                            "
                       "\n                        Some server implementations require user name  and  password"
                       "\n                        to authenticate the user.                                   " 
                       "\n  -k,--keystore [PEM]   PEM file that is contained identity of the client ( private," 
                       "\n                        certificate ).  The  private  key  must  be  encrypted form." 
                       "\n  -p,--password         Used to decrypt the private key in keystore."      	
                       "\n  -t,--truststore [PEM] PEM file that contains the trusted CA, the only ones who can"
                       "\n                        vouch for the identity of the server."
                       "\n  -c,--ciphersuite {cipher1,cipher2,...,cipherN}"
                       "\n                        Ciphersuite  list  of  proposals  to the server, in order of"
                       "\n                        preference.   The  values  are  separated  with  no  spaces." 
                       "\n                        Complete List of supported cipher:NULL-{MD5|SHA},RC2-CBC-MD5"
                       "\n                        RC4-{MD5|SHA}, EXP-RC2-CBC-MD5, EXP-RC4-MD5, EXP-DES-CBC-SHA"
                       "\n                        DES-CBC-{MD5|SHA},DES-CBC3-{MD5|SHA}, AES128-SHA, AES256-SHA"
                       "\n  -s,--ssl-version version"
                       "\n                        Complete List of version supported: SSLv2|SSLv3|TLSv1"
                       "\n  -T,--type-operation {operation-1|operation-2|...|operation-N}]"
                       "\n                        ..."
                       "\n  -Ml,--message-language [language]"
                       "\n                        ..."
                       "\n  -Mt,--message-type {type-1|type-2|...|type-N}]"
                       "\n                        ..."
                       "\n  -M,--message message"
                       "\n                        ..."
                       "\n  -S,--ssl-ciphersuite-server-scan"
                       "\n                        ..."
                       "\n  -m,--max-request max-request"
                       "\n                        ..."
                       "\n  -o,--output-file      ..."
                       "\n  -d,--debug            ..."
                       "\n  -f,--config [filename]" 
                       "\n                        Configuration file, as an alternative to the  parameters  on" 
                       "\n                        the command line. [function not yet implemented]"
                       "\n  --help                Print this help and quit."
                       "\n  --version             Print the version and quit." 
                       "\n" },
              
                     /*
                     .---------------------------------.
                     |                                 |
                     |           Return Code           |
                     |                                 |
                     '---------------------------------' */
                     { "MY_CLIENT_TCP__RETURN_CODE", 
                       "__INFO__",
                       "\nExit to 0 if everything is OK, -1 if there is a problem." }, 

                     /*
                     .---------------------------------.
                     |                                 |
                     |           Bug Report            |
                     |                                 |
                     '---------------------------------' */
                     { "MY_CLIENT_TCP__BUG_REPORT", 
                       "__INFO__",
                       "\nReport bugs to <raffaele.granito@tiscali.it>.\n\n" }, 

                     /*
                     .---------------------------------.
                     |                                 |
                     |              Version            |
                     |                                 |
                     '---------------------------------' */
                     { "MY_CLIENT_TCP__VERSION",
                       "__INFO__",
                       "\nVersion 0.0.5\n\n" }, 


                     /*
                     .----------------------------------------------------------------. 
                     |                                                                |
                     |         Coppie Parametro|Valore in cui manca il valore         |
                     |                                                                |
                     '----------------------------------------------------------------' */

                     { "MY_CLIENT_TCP__ERRORE_ATTESO_PARAMETRO_CONNECT",
                       "__INFO__",
                       "Error. Missing for -c|--connect parameter the connection string.\n" },

                     { "MY_CLIENT_TCP__ERRORE_ATTESO_PARAMETRO_AUTH_USER",
                       "__INFO__",
                       "Error. Missing for -U|--auth-user parameter.\n" },

                     { "MY_CLIENT_TCP__ERRORE_ATTESO_PARAMETRO_AUTH_PASSWORD",
                       "__INFO__",
                       "Error. Missing for -P|--auth-password parameter.\n" },

                     { "MY_CLIENT_TCP__ERRORE_ATTESO_PARAMETRO_KEYSTORE",
                       "__INFO__",
                       "Error. Missing for -k|--keystore parameter the keystore file.\n" },

                     { "MY_CLIENT_TCP__ERRORE_ATTESO_PARAMETRO_KEYSTORE_PASSWORD",
                       "__INFO__",
                       "Error. Missing for -p|--password parameter the secret string.\n" },

                     { "MY_CLIENT_TCP__ERRORE_ATTESO_PARAMETRO_TRUSTSTORE",
                       "__INFO__",
                       "Error. Missing for -t|--truststore parameter the truststore file.\n" },

                     { "MY_CLIENT_TCP__ERRORE_ATTESO_PARAMETRO_CIPHERSUITE",
                       "__INFO__",
                       "Error. Missing for -C|--chipersuite parameter ciphersuite valid value.\n" },

                     { "MY_CLIENT_TCP__ERRORE_ATTESO_PARAMETRO_VERSION_SSL", 
                       "__INFO__",
                       "Error. Missing for -s|--ssl-version parameter version ssl valid value.\n" },

                     { "MY_CLIENT_TCP__ERRORE_ATTESO_PARAMETRO_TYPE_OPERATION",
                       "__INFO__",
                       "Error. Missing for -T|--type-operation parameter value.\n" },

                     { "MY_CLIENT_TCP__ERRORE_ATTESO_PARAMETRO_MESSAGE_LANGUAGE",
                       "__INFO__",
                       "Error. Missing for -Ml|--message-language parameter value.\n" },

                     { "MY_CLIENT_TCP__ERRORE_ATTESO_PARAMETRO_MESSAGE_TYPE",
                       "__INFO__",
                       "Error. Missing for -Mt|--message-type parameter value.\n" },

                     { "MY_CLIENT_TCP__ERRORE_ATTESO_PARAMETRO_MESSAGE",
                       "__INFO__",
                       "Error. Missing for -M|--message parameter value.\n" },

                     { "MY_CLIENT_TCP__ERRORE_ATTESO_PARAMETRO_SSL_CIPHERSUITE_SERVER_SCAN",
                       "__INFO__",
                       "Error. Missing for -S|--ssl-ciphersuite-server-scan parameter value.\n" },

                     { "MY_CLIENT_TCP__ERRORE_ATTESO_PARAMETRO_MAX_REQUEST",
                       "__INFO__",
                       "Error. Missing for -m|--max-request parameter value.\n" },

                     { "MY_CLIENT_TCP__ERRORE_ATTESO_PARAMETRO_OUTPUT_FILE",
                       "__INFO__",
                       "Error. Missing for -o|--output-file parameter value.\n" },

                     { "MY_CLIENT_TCP__ERRORE_ATTESO_PARAMETRO_CONFIGURATION_FILE",
                       "__INFO__",
                       "Error. Missing for -f|--config parameter configuration file.\n" },

                     { "MY_CLIENT_TCP__ERRORE_ATTESO_PARAMETRO_DEBUG",
                       "__INFO__",
                       "Error. Missing for -d|--debug parameter.\n" },


                     /*
                     .------------------------------------------------------------------.
                     |                                                                  |
                     |       Coppie Parametro/Valore specificate più di una volta       |
                     |                                                                  |
                     '------------------------------------------------------------------' */
                     { "MY_CLIENT_TCP__ERRORE_DUPLICATE_PARAMETRO_CONNECT",
                       "__INFO__",
                       "Error. Duplicate -c|--connect parameter.\n" },

                     { "MY_CLIENT_TCP__ERRORE_DUPLICATE_PARAMETRO_AUTH_USER",
                       "__INFO__",
                       "Error. Duplicate -U|--auth-user parameter.\n" },

                     { "MY_CLIENT_TCP__ERRORE_DUPLICATE_PARAMETRO_AUTH_PASSWORD",
                       "__INFO__",
                       "Error. Duplicate -P|--auth-password parameter.\n" },

                     { "MY_CLIENT_TCP__ERRORE_DUPLICATE_PARAMETRO_KEYSTORE",
                       "__INFO__",
                       "Error. Duplicate -k|--keystore parameter.\n" },

                     { "MY_CLIENT_TCP__ERRORE_DUPLICATE_PARAMETRO_KEYSTORE_PASSWORD",
                       "__INFO__",
                       "Error. Duplicate -p|--password parameter.\n" },

                     { "MY_CLIENT_TCP__ERRORE_DUPLICATE_PARAMETRO_TRUSTSTORE",
                       "__INFO__",
                       "Error. Duplicate -t|--truststore parameter.\n" },

                     { "MY_CLIENT_TCP__ERRORE_DUPLICATE_PARAMETRO_CIPHERSUITE",
                       "__INFO__",
                       "Error. Duplicate -C|--chipersuite parameter.\n" },

                     { "MY_CLIENT_TCP__ERRORE_DUPLICATE_PARAMETRO_SSLVERSION",
                       "__INFO__",
                       "Error. Duplicate -s|--ssl-version parameter.\n" },

                     { "MY_CLIENT_TCP__ERRORE_DUPLICATE_PARAMETRO_TYPE_OPERATION",
                       "__INFO__",
                       "Error. Duplicate -T|--type-operation parameter.\n" },

                     { "MY_CLIENT_TCP__ERRORE_DUPLICATE_PARAMETRO_MESSAGE_LANGUAGE",
                       "__INFO__",
                       "Error. Duplicate -Ml|--message-language parameter.\n" },

                     { "MY_CLIENT_TCP__ERRORE_DUPLICATE_PARAMETRO_MESSAGE_TYPE",
                       "__INFO__",
                       "Error. Duplicate -Mt|--message-type parameter.\n" },

                     { "MY_CLIENT_TCP__ERRORE_DUPLICATE_PARAMETRO_MESSAGE",
                       "__INFO__",
                       "Error. Duplicate -M|--message parameter.\n" },

                     { "MY_CLIENT_TCP__ERRORE_DUPLICATE_PARAMETRO_SSL_CIPHERSUITE_SERVER_SCAN",
                       "__INFO__",
                       "Error. Duplicate -S|--ssl-ciphersuite-server-scan parameter.\n" },

                     { "MY_CLIENT_TCP__ERRORE_DUPLICATE_PARAMETRO_MAX_REQUEST",
                       "__INFO__",
                       "Error. Duplicate -m|--max-request parameter.\n" },

                     { "MY_CLIENT_TCP__ERRORE_DUPLICATE_PARAMETRO_OUTPUT_FILE",
                       "__INFO__",
                       "Error. Duplicate -s|--output-file parameter.\n" },

                     { "MY_CLIENT_TCP__ERRORE_DUPLICATE_PARAMETRO_DEBUG",
                       "__INFO__",
                       "Error. Duplicate -d|--debug parameter.\n" },

                     { "MY_CLIENT_TCP__ERRORE_UNKNOWN_PARAMETRO",
                       "__INFO__",
                       "Error. Unknown Parameter.\n" },


                     /*
                     .------------------------------------------------------------------.
                     |                                                                  |
                     |           Stringa di connessione non valida. Motivazioni.        |
                     |                                                                  |
                     '------------------------------------------------------------------' */
                     { "MY_CLIENT_TCP__ERRORE_STRINGA_CONNESSIONE_PROTOCOLLO",
                       "__INFO__",
                       "Error. Error. Connection string incorrect. Protocol invalid (missing value).\n" },

                     { "MY_CLIENT_TCP__ERRORE_STRINGA_CONNESSIONE_PROTOCOLLO_NOSEP",
                       "__INFO__",
                       "Error. Error. Connection string incorrect. Missing :// between protocol and hostname.\n" },

                     { "MY_CLIENT_TCP__ERRORE_STRINGA_CONNESSIONE_HOSTNAME",
                       "__INFO__",
                       "Error. Error. Connection string incorrect. Host invalid (missing value).\n" },

                     { "MY_CLIENT_TCP__ERRORE_STRINGA_CONNESSIONE_PORTA_NONUM",
                       "__INFO__",
                       "Error. Connection string incorrect. Port invalid (missing value or not numeric).\n" },

                     { "MY_CLIENT_TCP__ERRORE_STRINGA_CONNESSIONE_PORTA_NORANGE",
                       "__INFO__",
                       "Error. Connection string incorrect. Port invalid (out of range 0..65535).\n" },

                     { "MY_CLIENT_TCP__ERRORE_STRINGA_CONNESSIONE_QUERY_NOSEPURL",
                       "__INFO__",
                       "Error. Connection string incorrect. Missing separatore URL/Query.\n" },

                     { "MY_CLIENT_TCP__ERRORE_STRINGA_CONNESSIONE_QUERY_LEN0",
                       "__INFO__",
                       "Error. Connection string incorrect. Query string invalid (missing).\n" },

                     { "MY_CLIENT_TCP__ERRORE_STRINGA_CONNESSIONE_QUERY_NOTLENMAX",
                       "__INFO__",
                       "Error. Connection string incorrect. Query string invalid (len > 1024 byte).\n" },

                     { "MY_CLIENT_TCP__ERRORE_STRINGA_CONNESSIONE_QUERY_NOSEPVAR",
                       "__INFO__",
                       "Error. Connection string incorrect. Query string missing variable separate character.\n" },

                     { "MY_CLIENT_TCP__ERRORE_STRINGA_CONNESSIONE_QUERY_VARLEN0",
                       "__INFO__",
                       "Error. Connection string incorrect. Query string has variable not definited.\n" },

                     { "MY_CLIENT_TCP__ERRORE_STRINGA_CONNESSIONE_QUERY_NOASSIGN",
                       "__INFO__",
                       "Error. Connection string incorrect. Query string missing a assign character.\n" },

                     { "MY_CLIENT_TCP__ERRORE_STRINGA_CONNESSIONE_UNKNOWN",
                       "__INFO__",
                       "Error. Connection string incorrect. Unknown error.\n" },


                     /*
                     .---------------------------------.
                     |                                 |
                     |       Controllo Parametri       |
                     |                                 |
                     '---------------------------------' */
                     { "MY_CLIENT_TCP__ERRORE_CONFIGURATION_FILE_NOTFOUND",
                       "__INFO__",
                       "Error. Configuration file not found or you have not permission.\n" },


                     /*
                     .---------------------------------.
                     |                                 |
                     |              Tappo              |
                     |                                 |
                     '---------------------------------' */
                     { "END", 
                       "NONE",
                       "End of Message Table. *Warning* Message not found.\n" }

    }; 

