#!/usr/bin/perl

#    The MySQL General Purpose Stored Routines Library
#    Copyright (C) 2005 Giuseppe Maxia, Stardata s.r.l.
#    Contacts: http://www.stardata.it/contatti_en.html
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

use strict;
use warnings;
use Data::Dumper;
use Regexp::Common;
use DBI;

my $HOST = shift || 'localhost';
my $DB   = shift || 'glob';
my $conf = shift || "$ENV{HOME}/.my.cnf";

my $dbh = DBI->connect(
    "DBI:mysql:$DB;"
    . "host=$HOST"
	. ";mysql_read_default_file=$conf",  
	undef, 
    undef, 
    {RaiseError => 1}) 
	or die qq(can't connect\n);

$dbh->do(qq{truncate _routine_parameters});

my %routines = (
    function    => [],
    procedure   =>[]
);

for my $rtype (sort keys %routines)
{
    $routines{$rtype} = $dbh->selectcol_arrayref(qq{
        select routine_name from _routine_syntax where routine_type=?}, undef, $rtype);

    for my $routine (@{ $routines{$rtype}  }) 
    {
        my (undef,undef,$create) = $dbh->selectrow_array(qq{show create $rtype $routine});
        my ($params) = $create =~ /($RE{balanced}{-parens=>'()'})/sm;
        print "$rtype $routine\n";
        my $sequence = 0;
        $params =~ s/^\(//;
        $params =~ s/\)\Z//;
        my ($id) = $dbh->selectrow_array(qq{select routine_id from _routine_syntax
                where routine_name = ? and routine_schema = database() 
                and routine_type = ? }, undef, $routine, $rtype);
        next unless $id;
        for my $par (split /\n/, $params)
        {
            $par =~ s/,\s*$//ms;
            $par =~ s/^\s+//;
            $par =~ s/\s+$//;
            next if $par =~ /^\s*$/;
            my ($par_name, $par_type) = $par =~ /^(\w+)\s+(.*)/;
            print "\t<$par_name> <$par_type>\n";
            $sequence++;
            $dbh->do(qq{insert into _routine_parameters 
                    (routine_id, parameter_name, parameter_type, parameter_sequence)
                    VALUES (?,?,?,?)
                    on duplicate key update parameter_name = ? ,
                        parameter_type = ? ,
                        parameter_sequence = ?
                    }, undef, $id, $par_name, $par_type, $sequence, $par_name, $par_name, $sequence);
        }
    }
}
