/* myerhtml.h - HTML parameters for Myer        -*- coding: latin-1 -*-

    2003 by Jonathan Yavner.  GPL license; see file COPYING for details.
*/

#ifndef MYERHTML_H
#define MYERHTML_H

/* To compute RGB from coupling, we first call pow(coupling,1/gamma) to
   brighten the dim colors and reduce the disparity among the bright colors.
   Do not use gamma values < 1.0! */
#define DEFAULT_GAMMA_COUPLING 1.75
#define DEFAULT_GAMMA_COHESION 1.25

/* Basic background and foreground for ordinary text.  We use pink as the
   background to increase contrast with dim blues. */
#define DEFAULT_COLOR_BG    (RGB_t){0xff,0xe7,0xe7} /* Pale pink */
#define DEFAULT_COLOR_FG    (RGB_t){0x60,0x60,0x60} /* Medium gray. */

/* For text that has been #ifdef'ed out */
#define DEFAULT_COLOR_IFDEF (RGB_t){0xc0,0xc0,0xc0} /* Light gray */

/* For local variables (so coupling/cohesion don't apply) */
#define DEFAULT_COLOR_LOCAL (RGB_t){0x00,0x7c,0x34} /* Green */

/* Basic algorithm for converting coupling/cohesion values into foreground
   colors.  The hue is blue for low coupling, increasing towards cyan.  The
   brightness is barely distinguishable from gray for high cohesion,
   increasing for poor cohesion. */
#define DEFAULT_COLOR_GLOBAL(coupling,cohesion) ({		 \
			float v = 0.4 + 0.6*cohesion;		 \
			int r = 0;				 \
			int g = (int) (255.0 * v * coupling);	 \
			int b = (int) (255.0 * v);		 \
			assert( r >= 0 && g >= 0 && b >= 0 );	 \
			assert( r < 256 && g < 256 && b < 256 ); \
			(RGB_t){ r, g, b };			 \
		})

#define DEFAULT_COLOR_MODLOCAL(cohesion) ({				\
			/* For module-local variables that have only	\
			   cohesion, convert blue to purple. */		\
			RGB_t rgb = DEFAULT_COLOR_GLOBAL(0,cohesion);	\
			rgb.r = rgb.b;					\
			rgb;						\
		})

    /* Use a pale-peach background for literal constants */
#define DEFAULT_HTML_STARTCONST "<span style=\"background-color: #f9e7c2\">"
#define DEFAULT_HTML_ENDCONST   "</span>"

#endif
