/* myerparse.c - Callback for gcc to produce tokens -*- coding: latin-1 -*-

   2003 by Jonathan Yavner.  GPL license; see file COPYING for details.
*/

#ifndef MYERTOK_H
#define MYERTOK_H


/* ----------------------------------------------------------------------------
   Interface between GCC and myerParse
*/

int Myer_mode; /* Set this if you want Myer-specific behavior */
#define MYER_MODE_ENABLE   1 /* Want Myer stuff */
#define MYER_MODE_READY    2 /* Hide defs emitted before program-start */

enum MYER_PARSE {
	MYER_PARSE_INVALID,
	MYER_PARSE_NUMBCONST,
	MYER_PARSE_CHARCONST,
	MYER_PARSE_STRCONST,
	MYER_PARSE_IDENT,
	MYER_PARSE_KEYWORD,
	MYER_PARSE_REPARSE_TYPE,
	MYER_PARSE_REF,
	MYER_PARSE_MARK_PUBLIC,
	MYER_PARSE_FILE_CHANGE,
	MYER_PARSE_FUNCSTART,
	MYER_PARSE_FUNCEND,
	MYER_PARSE_END_STATEMENT,
	MYER_PARSE_MACRO_DEF,
	MYER_PARSE_MACRO_REF,
	MYER_PARSE_START_SKIPPING,
	MYER_PARSE_END_SKIPPING,
	MYER_PARSE_IMPLICIT_FUNCDEF,
	MYER_PARSE_DEF,
	MYER_PARSE_END_INPUT,
	MYER_PARSE_SKIPINCLUDE,
	MYER_PARSE_MARK_DECL,
	MYER_PARSE_STRUCT_START,
	MYER_PARSE_STRUCT_END
};

void myerParse( enum MYER_PARSE, ... );
#endif
