;;; Guile bindings for Mutt
;;; Copyright (C) 2003  Ludovic Courts

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License
;;; as published by the Free Software Foundation; either version 2
;;; of the License, or (at your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


(mutt-module (mutt helpers send)
	     #:documentation
"Helper functions for preparing and sending messages.")



(define-public (build-simple-message subject rcpt filename)
  "Return a message whose recipient is @var{rcpt} (an address), and
whose contents are stored in @var{filename}.  If @var{reply-message} is
not false, the act as if replying to it."
  (let* ((msg  (create-message))
	 (env  (create-envelope))
	 (body (create-body)))
    (set! (envelope-to env) rcpt)
    (set! (envelope-from env) (default-from-address))
    (set! (envelope-subject env) subject)
    (set! (envelope-message-id env) (generate-message-id))
    (set! (envelope-user-headers env)
	  (append  ;;; One might choose to remove this
	   (user-headers)
	   '("X-Useless: How is everything today?"
	     "X-Message-Flag: Automagically sent by Guile-enabled Mutt")))
    ; Just to see what happens...
    (set! (envelope-user-headers env) (envelope-user-headers env))
    (set! (body-filename body) filename)
    (set! (body-content-type body) '("text" . "plain"))
    (set! (body-parameters body)
	  '(("charset"  . "iso-8859-1")
;	    ("format"   . "flowed")
	    ("encoding" . "8bit")))
    
    (set! (message-envelope msg) env)
    (set! (message-body msg) body)
    msg))

(define-public (update-message-references message replied-message)
  "Update the references of @var{message} based on the fact that it
replies to @var{replied-message}."
  (let* ((envelope (message-envelope message))
	 (replied-envelope (message-envelope replied-message))
	 (replied-id (envelope-message-id replied-envelope))
	 (replied-refs (envelope-references replied-envelope)))
    (set! (envelope-references envelope)
	  (append (if replied-id (list replied-id) '())
		  (if replied-refs replied-refs '())))))