/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import org.nongnu.multigraph.Edge;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.Node;
import org.nongnu.multigraph.PluggableObservable;

public class MultiDiGraph<N, E>
extends PluggableObservable
implements Graph<N, E> {
    HashMap<N, Node<N, E>> nodes;
    private Set<N> nodeset;
    protected PluggableObservable edge_events = new PluggableObservable();

    public MultiDiGraph() {
        this.nodes = new HashMap();
        this.nodeset = this.nodes.keySet();
    }

    final Node<N, E> get_node(N user_node) {
        Node<N, E> n = this.nodes.get(user_node);
        if (n == null) {
            n = new Node(user_node);
            this.nodes.put(user_node, n);
        }
        return n;
    }

    final void _set(Node<N, E> nf, Node<N, E> nt, int weight, E label) {
        assert (nf != null);
        assert (nt != null);
        assert (label != null);
        nf.set(nt, weight > 0 ? weight : 1, label);
    }

    protected void _set(N from, N to, int weight, E label) {
        Node<N, E> nt = null;
        assert (from != null);
        Node<N, E> nf = this.get_node(from);
        nt = to == null || to == from ? nf : this.get_node(to);
        this._set((N)nf, (N)nt, weight, label);
        this.setChanged();
        this.notifyObservers(from);
        this.notifyObservers(to);
        this.edge_events.notifyObservers(label);
    }

    @Override
    public synchronized void set(N from, N to, E label) {
        this._set(from, to, 1, label);
    }

    @Override
    public synchronized void set(N from, N to, E label, int weight) {
        this._set(from, to, weight, label);
    }

    protected boolean _remove(N from, N to, E label) {
        Node<N, E> nt = null;
        if (from == null) {
            throw new NullPointerException("remove: 'from' must not be null");
        }
        if (to == null) {
            throw new NullPointerException("remove: 'from' must not be null");
        }
        Node<N, E> nf = this.nodes.get(from);
        if (nf == null) {
            return false;
        }
        Node<N, E> node = nt = to == from ? nf : this.nodes.get(to);
        if (nt == null) {
            return false;
        }
        this.setChanged();
        if (label != null) {
            boolean ret = nf.remove(nt, label);
            this.edge_events.notifyObservers(label);
            this.notifyObservers(from);
            return ret;
        }
        boolean ret = nf.remove(nt);
        this.notifyObservers(to);
        this.notifyObservers(from);
        this.edge_events.notifyObservers(label);
        return ret;
    }

    @Override
    public synchronized boolean remove(N from, N to, E label) {
        return this._remove(from, to, label);
    }

    @Override
    public synchronized boolean remove(N from, N to) {
        return this._remove(from, to, null);
    }

    @Override
    public synchronized Set<Edge<N, E>> edges(N from) {
        Node<N, E> n = this.nodes.get(from);
        if (n == null) {
            return null;
        }
        return n.edges();
    }

    @Override
    public synchronized Stream<Edge<N, E>> stream(N from) {
        Node<N, E> n = this.nodes.get(from);
        if (n == null) {
            return null;
        }
        return n.stream();
    }

    @Override
    public synchronized Collection<Edge<N, E>> edges(N from, N to) {
        Node<N, E> nf = this.nodes.get(from);
        if (nf == null) {
            return null;
        }
        Node<N, E> nt = this.nodes.get(to);
        if (nt == null) {
            return null;
        }
        return nf.edges(nt);
    }

    @Override
    public Edge<N, E> edge(N from, N to) {
        Node<N, E> nf = this.nodes.get(from);
        if (nf == null) {
            return null;
        }
        Node<N, E> nt = this.nodes.get(to);
        if (nt == null) {
            return null;
        }
        return nf.edge(nt);
    }

    @Override
    public Edge<N, E> edge(N from, N to, E label) {
        Collection<Edge<N, E>> edges = this.edges(from, to);
        if (edges == null) {
            return null;
        }
        for (Edge<N, E> e : edges) {
            if (e.label() != label) continue;
            return e;
        }
        return null;
    }

    @Override
    public synchronized Set<N> successors(N node) {
        HashSet<N> sc = new HashSet<N>();
        assert (node != null);
        Node<N, E> n = this.nodes.get(node);
        if (n == null) {
            return null;
        }
        for (Edge<N, E> e : n.edges()) {
            sc.add(e.to());
        }
        return sc;
    }

    @Override
    public synchronized int edge_outdegree(N node) {
        return this.get_node(node).edge_outdegree();
    }

    @Override
    public synchronized int nodal_outdegree(N node) {
        return this.get_node(node).nodal_outdegree();
    }

    @Override
    public synchronized float avg_nodal_degree() {
        float avg = 0.0f;
        int num = 0;
        for (Node<N, E> n : this.nodes.values()) {
            avg += ((float)n.nodal_outdegree() - avg) / (float)(++num);
        }
        return avg;
    }

    @Override
    public synchronized long link_count() {
        long num = 0L;
        for (Node<N, E> n : this.nodes.values()) {
            num += (long)n.nodal_outdegree();
        }
        return num / 2L;
    }

    @Override
    public synchronized int max_nodal_degree() {
        int max = 0;
        for (Node<N, E> n : this.nodes.values()) {
            int d = n.nodal_outdegree();
            if (d <= max) continue;
            max = d;
        }
        return max;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        for (Node<N, E> n : this.nodes.values()) {
            sb.append(n + "\n");
            for (Edge<N, E> e : n.edges()) {
                sb.append("\t" + e + "\n");
            }
        }
        return sb.toString();
    }

    @Override
    public Iterable<N> random_node_iterable() {
        return new Iterable<N>(){

            @Override
            public Iterator<N> iterator() {
                ArrayList al = new ArrayList(MultiDiGraph.this);
                Collections.shuffle(al);
                return al.iterator();
            }
        };
    }

    @Override
    public Iterable<Edge<N, E>> random_edge_iterable(final N n) {
        return new Iterable<Edge<N, E>>(){

            @Override
            public Iterator<Edge<N, E>> iterator() {
                ArrayList al = new ArrayList(MultiDiGraph.this.edges(n));
                Collections.shuffle(al);
                return al.iterator();
            }
        };
    }

    @Override
    public boolean add(N node) {
        return this.get_node(node) != null;
    }

    @Override
    public boolean addAll(Collection<? extends N> c) {
        boolean ret = false;
        for (N n : c) {
            if (!this.add(n)) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public void clear() {
        this.nodes.clear();
        this.setChanged();
        this.notifyObservers();
        this.edge_events.notifyObservers();
    }

    @Override
    public boolean contains(Object o) {
        return this.nodeset.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.nodeset.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.nodeset.equals(o);
    }

    @Override
    public int hashCode() {
        return this.nodeset.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.nodeset.isEmpty();
    }

    @Override
    public int size() {
        return this.nodeset.size();
    }

    @Override
    public Object[] toArray() {
        return this.nodeset.toArray();
    }

    @Override
    public <N> N[] toArray(N[] a) {
        return this.nodeset.toArray(a);
    }

    @Override
    public Iterator<N> iterator() {
        return this.nodeset.iterator();
    }

    @Override
    public void clear_all_edges() {
        for (Node<N, E> n : this.nodes.values()) {
            n.clear();
        }
        this.setChanged();
        this.notifyObservers();
        this.edge_events.notifyObservers();
    }

    @Override
    public synchronized boolean remove(Object o) {
        Node<N, E> node = this.nodes.get(o);
        boolean ret = false;
        if (node == null) {
            return false;
        }
        for (Object oe : node.edges().toArray()) {
            Edge e = (Edge)oe;
            if (!this.remove(e.from(), e.to(), e.label())) continue;
            ret = true;
        }
        this.notifyObservers(o);
        return this.nodeset.remove(o) ? true : ret;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int size1 = this.size();
        for (Object o : c) {
            this.remove(o);
        }
        return size1 == this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        int size1 = this.size();
        for (N node : this) {
            if (c.contains(node)) continue;
            this.remove(node);
        }
        return size1 == this.size();
    }

    @Override
    public boolean is_directed() {
        return true;
    }

    @Override
    public boolean is_simple() {
        return false;
    }

    @Override
    public boolean is_linked(N from, N to) {
        Node<N, E> nf = this.nodes.get(from);
        if (nf == null) {
            return false;
        }
        Node<N, E> nt = this.nodes.get(to);
        if (nt == null) {
            return false;
        }
        return nf.isLinked(nt);
    }

    @Override
    public PluggableObservable edge_events() {
        return this.edge_events;
    }
}

