<?php
########################################################################
# MuGLIn - MuGLIn GNU/Linux Installation		                       #
#                                                                      #
# Copyright (C) 2010 Jakob Gurnhofer <jakob.gurnhofer@gmail.com>       #
# Copyricht (C) 2010 Srdjan Markovic <smark2ki@htl.moedling.at>        #
#                                                                      #
# This file is part of MuGLIn source code.                             #
#                                                                      #
# MuGLIn is free software: you can redistribute it and/or modify       #
# it under the terms of the GNU General Public License as published by #
# the Free Software Foundation, either version 3 of the License, or    #
# (at your option) any later version.                                  #
#                                                                      #
# MuGLIn is distributed in the hope that it will be useful,            #
# but WITHOUT ANY WARRANTY; without even the implied warranty of       #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        #
# GNU General Public License for more details.                         #
#                                                                      #
# You should have received a copy of the GNU General Public License    #
# along with MuGLIn. If not, see <http://www.gnu.org/licenses/>.       #
########################################################################

	include "/usr/local/lib/muglin/php/functions.php";
	include "/usr/local/lib/muglin/php/Sessions_functions.php";
	include "/usr/local/lib/muglin/php/Images_functions.php";
	get_conf("/etc/muglin/webiface.conf",&$web);
	get_conf("/etc/muglin/base.conf",&$base);
	$Connection=muglin_connect();
?>
<html>
<head>
	<script type="text/JavaScript" src="functions.js"></script>
	<script type="text/JavaScript">
		function show_Starton_Value()
		{
			switch(document.shownew.Starton.value)
			{
				case 'manual':
					document.shownew.num.value="manual";
					document.shownew.num.readOnly=true;
					break;
				case 'numofclients':
					document.shownew.num.value='0';
					document.shownew.num.readOnly=false;
					break;
				case 'timeout':
					document.shownew.num.value='in sec';
					document.shownew.num.readOnly=false;
					break;
			}
		}
		function num_onclick()
		{
			switch(document.shownew.num.value)
			{
				case '0':
					document.shownew.num.value='';
					break;
				case 'in sec':
					document.shownew.num.value='';
					break;
			}
		}
	</script>
</head>
<body style="background-image:url('../Images/<?php echo $web['bgimage'];?>');">
<?php
	switch($_GET['action'])
	{
		case 'start':
			mod_Session($_GET['SID'],'start');
			break;
		case 'cancel':
			mod_Session($_GET['SID'],'cancel');
			break;
		case 'delete':
			mod_Session($_GET['SID'],'delete');
			break;
		case 'new':
			$SName=$_POST['Name'];
			$IName=$_POST['IName'];
			$Starton=$_POST['Starton'];
			if($Starton=="timeout") $Starton=$Starton." -t ".$_POST['num'];
			if($Starton=="numofclients") $Starton=$Starton." -m ".$_POST['num'];
			new_Session($SName,$IName,$Starton);
			sleep(2);
			break;
		case 'clear':
			clear_Sessions();
			break;
		case 'shownew':
			$Images=get_Data("Images");
			?>
			<form name='shownew' method="POST" action="./Sessions.php?action=new">
				<table>
					<tr><td>Name:</td><td><input type='text' name='Name' /></td></tr>
					<tr><td>Image:</td><td><select name='IName'>
					<?php
						for($i=0;$Images[$i];$i++)
						{
							if($Images[$i]['Enabled'])
							{
								echo "<option value='".$Images[$i]['Name']."'>".$Images[$i]['Name']."</option>";
							}
						}
					?>
					</select></td></tr>
					<tr><td>Starton:</td><td><select name='Starton' onchange='show_Starton_Value()'>
						<option value='timeout'>timeout</option><option value='numofclients'>numofclients</option><option value='manual'>manual</option>
					</select></td>
					<td>Value:</td><td><input type='text' onclick='num_onclick()' name='num' value='in sec' /></td></tr>
					<tr><td></td><td><input type='submit' name='irgendwas' value='Create' /></td></tr>
				</table>
			</form>
			<?php
			break;
	}
?>
<h1>Sessions:</h1>
<table border='1'>
	<tr><th>Name</th><th>Image</th><th>Status</th><th>Baseport</th><th>Connected Peers</th><th>Actions</th></tr>
	<?php 
		$Sessions=get_Data("Sessions");
		for($i=0;$Sessions[$i];$i++)
		{
			echo "<tr><td>".$Sessions[$i]['Name']."</td>";
			echo "<td>".$Sessions[$i]['IName']."</td>";
			$state=change_Session_State($Sessions[$i]['State']);
			echo "<td>".$state."</td>";
			echo "<td>".$Sessions[$i]['Baseport']."</td>";
			echo "<td>".$Sessions[$i]['peers']."</td>";
			switch($Sessions[$i]['State'])
			{
				case '0':
					echo "<td><a href='./Sessions.php?SID=".$Sessions[$i]['SID']."&action=start'><img src='../Images/start.png' alt='Start' /></a>";
					echo "<a href='./Sessions.php?SID=".$Sessions[$i]['SID']."&action=delete'><img src='../Images/delete.png' alt='Delete' /></a></td>";
					break;
				case '1':
					echo "<td><a href='./Sessions.php?SID=".$Sessions[$i]['SID']."&action=cancel'><img src='../Images/cancel.png' alt='Cancel' /></a></td>";
					break;
				case '2':
					echo "<td><a href='./Sessions.php?SID=".$Sessions[$i]['SID']."&action=delete'><img src='../Images/delete.png' alt='Delete' /></a></td>";
					break;
				case '3':
					echo "<td><a href='./Sessions.php?SID=".$Sessions[$i]['SID']."&action=delete'><img src='../Images/delete.png' alt='Delete' /></a></td>";
					break;
			}
			echo "</tr>";
		}
?>
</table>
<a href='./Sessions.php?action=shownew'>New Session...</a><br />
<a href='./Sessions.php?action=clear'>Clear unused Sessions...</a>
</body>
</html>
