// muesli-ruby.c -*- C -*-
/* Interface to ruby evaluators / template for new language interfaces
   Copyright (C) 2008, 2009, 2010 University of Limerick

   This file is part of Muesli.
   
   Muesli is free software: you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your
   option) any later version.
   
   Muesli is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.
   
   You should have received a copy of the GNU General Public License
   along with Muesli.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _MUESLI_RUBY_
#define _MUESLI_RUBY_

#include "../config.h"
#include "muesli.h"

#ifdef HAVE_LIBRUBY_STATIC

#include <stdio.h>
#include <limits.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <getopt.h>		// todo: do I need this?

#if 0
/* todo: must do something about INCLUDEPATH */
#include <ruby.h>
#endif

static int ambient_transient = 0;

// A specialized non-local exit; could either throw, or just quit the
// application run:
void ruby_error(char *message, char *arg)
{
  fprintf(stderr, "Got error \"%s\", \"%s\"\n", message, arg);
}

static evaluator_interface *ruby_interface = NULL;

static char *option_names_var_name = (char*)"option_names";

#if 0
static muesli_value_t
ruby_to_muesli(VALUE rubyval)
{
  muesli_value_t mval;
  ANULL_VALUE(mval);

  switch (TYPE(rubyval)) {
  case T_FIXNUM:
    mval.data.as_int = FIX2LONG(rubyval);
    mval.type = muesli_value_integer;
    break;
  case T_FLOAT:
    {
      f = NUM2DBL(rubyval);
      mval.data.as_float = f;
      mval.type = muesli_value_float;
    }
    break;
  case T_STRING:
    {
      char *s = StringValueCStr(rubyval);
      mval.data.as_string = muesli_malloc_copy_string(s);
      mval.type = muesli_value_string;
    }
    break;
  case T_SYMBOL:
    break;
  case T_TRUE:
    mval.data.as_bool = 1;
    mval.type = muesli_value_boolean;
    break;
  case T_FALSE:
  case T_NIL:
    mval.data.as_bool = 0;
    mval.type = muesli_value_boolean;
    break;
  default:
    /* raise exception */
    rb_raise(rb_eTypeError, "not valid value");
    break;
  }
}
#endif

#if 0
static void
ruby_set_parameter()
{
  if (ruby_count_args(cs) < 2) {
    fprintf(stderr, "too few args to ruby_set_parameter\n");
    ruby_error(cs, (char*)"argcount", (char*)"set_parameter");
  }

  char option_code = muesli_find_option_letter(ruby_interface->getopt_options, ruby_string_arg(cs, 0));

  if (option_code != -1) {
    if (ruby_arg_is_string(cs, 1)) {
      (ruby_interface->handle_option)(ruby_interface->app_params,
					option_code,
					muesli_malloc_copy_string(ruby_string_arg(cs, 1)),
					0.0, 1,
					"ruby");
    } else if (ruby_arg_is_number(cs, 1)) {
      (ruby_interface->handle_option)(ruby_interface->app_params,
					option_code, NULL, ruby_number_arg(cs, 2), 1,
					"ruby");
    } else {
      (ruby_interface->handle_option)(ruby_interface->app_params,
					option_code, (char*)"true", 0.0, 1,
					"ruby");
    }
  }
}

static void
ruby_set_parameters()
{
  if (ruby_count_args(cs) < 1)  {
    fprintf(stderr, "too few args to ruby_set_parameters\n");
    ruby_error(cs, (char*)"argcount", (char*)"set_parameters");
  }

#if 0
  // Fill in: use a table iterator from your language
  ruby_table table = ruby_table_arg(cs, 0);

  ruby_table_iteration_start(cs, table);
  while (ruby_table_iteration_next(cs, table) != 0) {
    ruby_set_parameter(cs,
			 ruby_table_iteration_current_key(cs, table),
			 ruby_table_iteration_current_value(cs, table));
  }

#endif
}

static void
ruby_get_parameter()
{
  if (ruby_count_args(cs) < 1)  {
    fprintf(stderr, "too few args to ruby_get_parameter\n");
    ruby_error(cs, (char*)"argcount", (char*)"get_parameter");
  }

  char option_code = muesli_find_option_letter(ruby_interface->getopt_options,
					       ruby_string_arg(cs, 0));

  if (option_code != -1) {

muesli_value_t result = (ruby_interface->handle_option)(ruby_interface->app_params,
							  option_code,	// option
							  NULL, 0.0,	// value
							  0,	// set
							  "ruby");

    switch (result.type) {
    case muesli_value_string:
      ruby_return_string(cs, result.data.as_string);
      break;
    case muesli_value_float:
      ruby_return_number(cs, result.data.as_float);
      break;
    case muesli_value_integer:
      ruby_return_integer(cs, result.data.as_int);
      break;
    case muesli_value_boolean:
      ruby_return_boolean(cs, result.data.as_int);
      break;
    default:
      ruby_return_boolean(cs, 0);
      break;
    }
  }
}

static void
ruby_get_parameters()
{
  ruby_table *table = ruby_create_table(cs, 48);

  // todo: fix and re-instate -- I have to get long_options across to it somehow
  struct option *option_names = ruby_interface->getopt_options;

  while (option_names->name != 0) {
    
    muesli_value_t result = (ruby_interface->handle_option)(ruby_interface->app_params,
							      (option_names->val), // opt
							      NULL, 0.0, // value
							      0, // set
							      "ruby");

    switch (result.type) {
    case muesli_value_string:
      ruby_set_table_string(cs, table, (char*)(option_names->name), result.data.as_string);
      break;
    case muesli_value_float:
      ruby_set_table_number(cs, table, (char*)(option_names->name), result.data.as_float);
      break;
    case muesli_value_boolean:
      ruby_set_table_boolean(cs, table, (char*)(option_names->name), result.data.as_int);
      break;
    default:
      ruby_set_table_boolean(cs, table, (char*)(option_names->name), 0);
      break;
    }
    option_names++;
  }
}
#endif

///////////////////////////////////////
// Call arbitrary evaluators by name //
///////////////////////////////////////

#if 0
static int
muesli_ruby_eval_in_language()
{
  if (ruby_count_args(cs) < 2) {
    fprintf(stderr, "too few args to ruby_eval_in_language\n");
    ruby_error(cs, (char*)"argcount", (char*)"eval_in_language");
    return 0;
  }

  if ((ruby_arg_is_string(cs, 1)) && (ruby_arg_is_string(cs, 2))) {
    const char *language_name = ruby_string_arg(cs, 1);
    const char *evaluand = ruby_string_arg(cs, 2);
    unsigned int evaluand_length = strlen(evaluand);

    fprintf(stderr, "In ruby_eval_in_language(\"%s\", \"%s\")\n", language_name, evaluand);

    muesli_value_t result = muesli_eval_in_language(language_name,
						    evaluand,
						    evaluand_length,
						    ambient_transient);

    switch (result.type) {
    case muesli_value_float:
      ruby_return_number(cs, result.data.as_float);
      break;
    case muesli_value_integer:
      ruby_return_integer(cs, result.data.as_int);
      break;
    case muesli_value_string:
      ruby_return_string(cs, result.data.as_string);
      break;
    case muesli_value_boolean:
      ruby_return_boolean(cs, result.data.as_bool);
      break;
    case muesli_value_none:
    case muesli_value_error:
      ruby_return_boolean(cs, 0);
      break;
    }
  } else {
    fprintf(stderr, "wrong type args to ruby_eval_in_language\n");
    ruby_error(cs, (char*)"argtype", (char*)"eval_in_language");
    return 0;
  }
  return 1;
}
#endif

///////////////////////////////
// Custom built-in functions //
///////////////////////////////

#if 0
static void
ruby_eval_custom_function()
{
  if (ruby_arg_is_string(cs, 0)) {
    char *string_arg = ruby_string_arg(cs, 0);
    muesli_value_t result = (ruby_interface->eval_string)(ruby_interface,
							    string_arg, strlen(string_arg),
							    ambient_transient);
    switch (result.type) {
    case muesli_value_float:
      ruby_return_number(cs, result.data.as_float);
      break;
    case muesli_value_integer:
      ruby_return_integer(cs, result.data.as_int);
      break;
    case muesli_value_string:
      ruby_return_string(cs, result.data.as_string);
      break;
    case muesli_value_boolean:
      ruby_return_boolean(cs, result.data.as_int);
      break;
    case muesli_value_none:
    case muesli_value_error:
      ruby_return_void(cs);
      break;
    }
  } else {
    fprintf(stderr, "ruby_eval_function must be given a string\n");
    ruby_error(cs, (char*)"argtype", (char*)"ruby_eval");
  }
}
#endif

////////////////
// Initialize //
////////////////

void
ruby_evaluator_init(evaluator_interface *interface)
{
  // Fill in: initialize your ruby application
  ruby_interface = interface;

  // Init ruby interface
  ruby_init();
  ruby_script((char*)"muesli");

  // Extend system

#if 0
  // Fill in: register all these language extensions (as applicable):
  Muesli_Add_Fn_1(interface, (char*)"get_parameter", ruby_get_parameter);
  Muesli_Add_Fn_2(interface, (char*)"set_parameter", ruby_set_parameter);
  Muesli_Add_Fn_0(interface, (char*)"evolution_parameters", ruby_get_parameters);
  Muesli_Add_Fn_1(interface, (char*)"modify_evolution_parameters", ruby_set_parameters);
  Muesli_Add_Fn_1(interface, (char*)"ruby", ruby_eval_function);
  Muesli_Add_Fn_1(interface, (char*)"eval_in_language", muesli_ruby_eval_in_language);
#endif

#if 0
  // Set up option names

  // Fill in: Create a table of option names.  You may well not need to bother.
  ruby_table *option_names_table = ruby_create_table(our_ruby_state, 48);
  struct option *option_names;
  for (option_names = ruby_interface->getopt_options;
       (option_names != NULL) && (option_names->name != 0);
       option_names++) {
    ruby_set_table_number(our_ruby_state, option_names_table,
			    (char*)(option_names->name), (option_names->val));
  }
  ruby_set_global_variable_table(our_ruby_state,
				   ruby_make_symbol(our_ruby_state,
						      option_names_var_name),
				   option_names_table);
#endif
}

static void
ruby_load_file(evaluator_interface *interface,
		const char *filename)
{
  int muesli_flags = interface->flags;
  if (muesli_flags & TRACE_MUESLI_LOAD) {
    fprintf(stderr, "Loading %s\n", filename);
  }
  // Fill in: load the functions file given as (char*)(filename)
  if (muesli_flags & TRACE_MUESLI_LOAD) {
    fprintf(stderr, "Loaded %s\n", filename);
  }
}

static muesli_value_t
ruby_eval_string(evaluator_interface *evaluator,
		   const char *ruby_c_string,
		   unsigned int string_length,
		   int transient)
{
  muesli_value_t result;
  ANULL_VALUE(result);

  if (ruby_c_string) {
    int old_ambient_transient = ambient_transient;
    ambient_transient = transient;
    // fprintf(stderr, "Ruby evaluating string \"%s\"\n", ruby_c_string);

    // Fill in: evaluate ruby_c_string, decide what kind of result
    // it returns, and fill in the result pointer and the result type
    // accordingly.



    ambient_transient = old_ambient_transient;
  }

  return result;
}

void
ruby_setup(evaluator_interface *new_ruby_interface)
{
  ruby_interface = new_ruby_interface;

  ruby_interface->eval_string = ruby_eval_string;
  ruby_interface->load_file = ruby_load_file;

#if 0
  ruby_interface->version = PACKAGE_VERSION;
#endif
}

#endif
#endif

