# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

class LinkPlugin < MsgCab::Plugin
  def start_plugin
    MsgCab::Callback.add_callback(:view_initialize, :add_uri_linker) do |view|
      view.add_anchor(:body, URILinker)
    end
  end

  class URILinker < MsgCab::WebApp::Anchor
    URIPat = URI.regexp('http').disable_capture
    include HTree.compile_template(<<'End')
<html>
  <span _template="replace_text(text)">
    <span _iter="text.split(/(#{LinkPlugin::URILinker::URIPat})/o).each//s">
      <span _if="/(#{LinkPlugin::URILinker::URIPat})/o =~ s" _else=non_uri>
        <a _attr_href="s"><span _call="next_anchor.replace_text(s)"></span></a>
      </span>
      <span _template="non_uri" _call="next_anchor.replace_text(s)"></span>
    </span>
  </span>
</html>
End
  end
end
