# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

require 'msgcab/callback'

class CitePlugin < MsgCab::Plugin
  def start_plugin
    MsgCab::Callback.add_callback(:view_initialize, :add_citation_colorizer) do
      |view|
      view.add_anchor(:body, CitationColorizer)
    end
  end

  class CitationColorizer < MsgCab::WebApp::Anchor
    def initialize(chain, view)
      super(chain, view)
      @prefixes = []
    end

    def citation_class(prefix)
      @prefixes |= [prefix]
      level = @prefixes.index(prefix) + 1
      "cite#{level}"
    end

    CitePrefix = /[ \t]*[-_.a-z0-9]+>+|[ \t]*[\]>|}+]/

    include HTree.compile_template(<<'End')
<span _template="replace_text(text)">
  <span _iter="text.each_line//line">
    <span _if="/\A(?:#{CitePlugin::CitationColorizer::CitePrefix})+/i =~ line"
       _else="non_citation">
      <span _attr_class="citation_class($&)">
        <span _call='next_anchor.replace_text(line)'></span>
      </span>
    </span>
    <span _template="non_citation" _call="next_anchor.replace_text(line)"></span>
  </span>
</span>
End
  end
end
