# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

require 'htree'
require 'msgcab/webapp/anchor'
require 'msgcab/callback'

module MsgCab
  module WebApp
    class View
      def initialize(webapp)
        @webapp = webapp
        @attributes = Hash.new
        @encoding = Config['encoding'] || HTree::Encoder.internal_charset
        @anchors = Hash.new
        MsgCab::Callback.run_callback(:view_initialize, self)
        @use_relative_uri = true
      end
      attr_reader :webapp
      attr_accessor :attributes
      attr_accessor :encoding
      attr_accessor :use_relative_uri

      # Add an anchor to the chain with specified name.
      # If the optional 3rd argument append is true, add the anchor to the
      # end of the chain.  Otherwise, add the anchor to the beginning of
      # the chain.
      def add_anchor(name, anchor, append = false)
        chain = @anchors[name] ||= Array.new
        if append
          chain << anchor
        else
          chain.unshift(anchor)
        end
      end

      def uri(path_info)
        if @use_relative_uri
          @webapp.make_relative_uri(:path_info => path_info)
        else
          @webapp.make_absolute_uri(:path_info => path_info)
        end
      end

      def output_template(name)
        path = Pathname.new(name)
        unless path.absolute?
          template_path = @webapp.resource_path(Config['webapp', 'template_path'] ||
                                                  './template')
          path = template_path + path
        end
        HTree.expand_template(path, self, @webapp, @encoding)
      end

      def load_template(name)
        path = Pathname.new(name)
        unless path.absolute?
          template_path = @webapp.resource_path(Config['webapp', 'template_path'] ||
                                                  './template')
          path = template_path + path
        end
        self.extend(HTree.compile_template(path))
      end

      private
      def new_anchor(name, view)
        chain = @anchors.fetch(name, Array.new).dup
        chain << Anchor
        chain.shift.new(chain, view)
      end

      include HTree.compile_template(<<End)
<div>
  <span _template="replace(name, view)">
    <span _call="new_anchor(name, view).replace"></span>
  </span>
  <span _template="replace_text(name, view, text)">
    <span _call="new_anchor(name, view).replace_text(text)"></span>
  </span>
</div>
End
    end

    module Language
    end
  end
end
