/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *                   GNU/linux version 3.0.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2006,2009,2010,2012 COLLARD Christophe
 * copyright © 2006,2009,2010,2012 Centre National de la Recherche Scientifique
 * copyright © 2006,2009,2010 Arts et Métiers ParisTech
 * copyright © 2006,2009,2010 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    tests-MPISOL++ belongs to Message Passing Interface for Simula+ Object Libraries (MPISOL++)
    MPISOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type interface.
#endif

#ifndef __mpi_h
#include <mpi.h>
#endif

#ifndef __iostream
#include <iostream>
#endif

#ifndef __fstream
#include <fstream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __time_h
#include <time.h>
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

#ifndef __broadcast_test_hpp
#include "broadcast-test.hpp"
#endif

//#if !defined(__SECURE_BROADCAST_TEST_H)
//#include "secure broadcast-test.h"
//#endif

#ifndef __send_receive_test_hpp
#include "send receive-test.hpp"
#endif

using namespace std;
using namespace mpisol;


main()
{
  bool detail; // parameter to write/hide test procedure
  bool result = true;
  clock_t start, end;
  clock_t start_main, end_main;

  int argc;
  char** argv;
  MPI::Init(argc, argv);
  int myrank = MPI::COMM_WORLD.Get_rank();

  if (!myrank)
    { detail = 1;
      start_main = start = clock();
      if (detail)
	//=======================================================================
	cout<< "-------------------------broadcast-------------------------- \n";
        //=======================================================================
    }
  result *= test_broadcast(detail);
  if (!myrank)
    { end = clock();
      cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

      cout << endl;

      detail = 1;
      start = clock();
      if (detail)
	//=======================================================================
	cout<< "------------------------send receive------------------------ \n";
        //=======================================================================
    }
  result *= test_send_receive(detail);
  if (!myrank)
    { end = clock();
      cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

      cout << endl;
    }

  MPI::Finalize();

  if (!myrank)
    { end_main = clock();
      cout << endl;

      cout << "============================================================== \n";
      if (result) cout << green << "-------OK------------end of MPIOL++ tests------------OK-------" << reset;
      else cout << red << "-----FAILED----------end of MPIOL++ tests----------FAILED-----" << reset;
      cout << "============================================================== \n";

      cout<<"cpu time : " << (long double)(end_main-start_main)/CLOCKS_PER_SEC << endl;
    }
}


