/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *                   GNU/linux version 3.0.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2006,2009,2010,2012 COLLARD Christophe
 * copyright © 2006,2009,2010,2012 Centre National de la Recherche Scientifique
 * copyright © 2006,2009,2010 Arts et Métiers ParisTech
 * copyright © 2006,2009,2010 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    broadcast-test belongs to Message Passing Interface for Simula+ Object Libraries (MPISOL++)
    MPISOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type broadcast-test.
#endif

#ifndef __broadcast_test_hpp
#define __broadcast_test_hpp


#ifndef __mpi_h
#include <mpi.h>
#endif

#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __vectors_hpp
#include "MOL++/vectors.hpp"
#endif

#ifndef __matrix_hpp
#include "MOL++/matrix.hpp"
#endif

#ifndef __symmatrix_hpp
#include "MOL++/symmatrix.hpp"
#endif

#ifndef __tensors2_hpp
#include "MOL++/tensors2.hpp"
#endif

#ifndef __symtensors2_hpp
#include "MOL++/symtensors2.hpp"
#endif

#ifndef __tensors3_hpp
#include "MOL++/tensors3.hpp"
#endif

#ifndef __tensors4_hpp
#include "MOL++/tensors4.hpp"
#endif

#ifndef __symtensors4_hpp
#include "MOL++/symtensors4.hpp"
#endif

#ifndef __polynoms_hpp
#include "MOL++/polynoms.hpp"
#endif

#ifndef __broadcast_hpp
#include "MPISOL++/broadcast.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace std;
using namespace mol;
using namespace mpisol;


//=============================
int test_broadcast (int detail)
//=============================
{
  int result=1;
  int myrank = MPI::COMM_WORLD.Get_rank();
  int nb_threads = MPI::COMM_WORLD.Get_size();

  int test = true;

  long double scalar = 0, value = 125.134745;

  if (!myrank) scalar = value;
  broadcast (scalar, 0);

  int tests[1];
  tests[0] = (scalar==value);
  if (myrank) MPI::COMM_WORLD.Isend (tests,1,MPI::INT,0,123);
  else for (int i=1; i<nb_threads; i++)
         { MPI::COMM_WORLD.Irecv (tests,1,MPI::INT,i,123);
	   test *= tests[0];
	 }

  if (!myrank)
    { if (detail) affiche ("broadcast scalar", test);
      else result *= (test);
    }

  //  cout << "Hello world, I'm process number " << myrank << endl << "I received the following scalar : " << scalar << endl;


  //-----vector-----------------------------------------------------------------------------------------------------------------------------

  vector<long double> u(9), u_mpi;
  u[1]=2.; u[2]=7.25; u[3]=14.67; u[4]=234.2; u[5]=0.; u[6]=0.543378; u[7]=13.; u[8]=0.; u[9]=45.;

  if (!myrank) u_mpi = u;
  broadcast (u_mpi, 0);

  tests[0] = (u_mpi==u);
  if (myrank) MPI::COMM_WORLD.Isend (tests,1,MPI::INT,0,123);
  else for (int i=1; i<nb_threads; i++)
	 { MPI::COMM_WORLD.Recv (tests,1,MPI::INT,i,123);
	   test *= tests[0];
	 }

  //  cout << "Hello world, I'm process number " << myrank << endl << "I received the following vector : " << u_mpi << endl;
  //  system("hostname");

  int test2 = true;
  if (myrank==1) u_mpi = vector<long double>(9);
  tests[0] = (u_mpi==u);
  if (myrank) MPI::COMM_WORLD.Isend (tests,1,MPI::INT,0,123);
  else for (int i=1; i<nb_threads; i++)
	 { MPI::COMM_WORLD.Recv (tests,1,MPI::INT,i,123);
	   test2 *= tests[0];
	 }

  if (!myrank)
    { test *= !test2;
      if (detail) affiche ("broadcast vector", test);
      else result *= (test);
    }


  //-----matrix-----------------------------------------------------------------------------------------------------------------------------

  u_mpi = u;
  matrix<long double> mat(5,9), mat_mpi;
  mat(1,1)=2; mat(1,2)=-1; mat(1,4)=.5; mat(1,7)=-.25; mat(1,9)=-2;
  mat(2,2)=1; mat(2,4)=-9;mat(2,6)=2.65; mat(2,7)=5.4; mat(2,8)=3;
  mat[3] = u;
  mat[4] =& u;
  mat(5,1)=2; mat(5,2)=7; mat(5,3)=-1; mat(5,4)=-5; mat(5,5)=-.321; mat(5,6)=1; mat(5,7)=-1; mat(5,6)=-1; mat(5,7)=2;

  if (!myrank) mat_mpi = mat;
  broadcast (mat_mpi, 0);

  tests[0] = (mat==mat_mpi);
  if (myrank) MPI::COMM_WORLD.Isend (tests,1,MPI::INT,0,124);
  else for (int i=1; i<nb_threads; i++)
	 { MPI::COMM_WORLD.Recv (tests,1,MPI::INT,i,124);
	   test *= tests[0];
	 }

  if (!myrank)
    if (detail) affiche ("broadcast matrix", test);
    else result *= (test);


  //-----symmatrix--------------------------------------------------------------------------------------------------------------------------

  u = u_mpi;
  symmatrix<long double> smat(9,9), smat_mpi;
  for(int i=1; i<=9; i++)
    for (int j=1; j<=9; j++)
      smat(i,j) = 5*j - i;
  smat[9] =& u;

  if (!myrank) smat_mpi = smat;
  broadcast (smat_mpi, 0);

  tests[0] = (smat==smat_mpi);
  if (myrank) MPI::COMM_WORLD.Isend (tests,1,MPI::INT,0,124);
  else for (int i=1; i<nb_threads; i++)
	 { MPI::COMM_WORLD.Recv (tests,1,MPI::INT,i,124);
	   test *= tests[0];
	 }

  if (!myrank)
    if (detail) affiche ("broadcast symmatrix", test);
    else result *= (test);


  //-----tensor2----------------------------------------------------------------------------------------------------------------------------

  tensor2<long double> tsr2(5,9), tsr2_mpi;
  tsr2(1,1)=2; tsr2(1,2)=-1; tsr2(1,4)=.5; tsr2(1,7)=-.25; tsr2(1,9)=-2;
  tsr2(2,2)=1; tsr2(2,4)=-9;tsr2(2,6)=2.65; tsr2(2,7)=5.4; tsr2(2,8)=3;
  u = u_mpi;
  tsr2[3] = u;
  tsr2[4] =& u;
  tsr2(5,1)=2; tsr2(5,2)=7; tsr2(5,3)=-1; tsr2(5,4)=-5; tsr2(5,5)=-.321; tsr2(5,6)=1; tsr2(5,7)=-1; tsr2(5,6)=-1; tsr2(5,7)=2;

  if (!myrank) tsr2_mpi = tsr2;
  broadcast (tsr2_mpi, 0);

  tests[0] = (tsr2==tsr2_mpi);
  if (myrank) MPI::COMM_WORLD.Isend (tests,1,MPI::INT,0,124);
  else for (int i=1; i<nb_threads; i++)
	 { MPI::COMM_WORLD.Recv (tests,1,MPI::INT,i,124);
	   test *= tests[0];
	 }

  if (!myrank)
    if (detail) affiche ("broadcast tensor2", test);
    else result *= (test);

  //-----symtensor2-------------------------------------------------------------------------------------------------------------------------

  u = u_mpi;
  symtensor2<long double> stsr(9,9), stsr_mpi;
  for(int i=1; i<=9; i++)
    for (int j=1; j<=9; j++)
      stsr(i,j) = 5*j - i;
  stsr[9] =& u;

  if (!myrank) stsr_mpi = stsr;
  broadcast(stsr_mpi,0);

  tests[0] = (stsr==stsr_mpi);
  if (myrank) MPI::COMM_WORLD.Isend (tests,1,MPI::INT,0,124);
  else for (int i=1; i<nb_threads; i++)
	 { MPI::COMM_WORLD.Recv (tests,1,MPI::INT,i,124);
	   test *= tests[0];
	 }

  if (!myrank)
    if (detail) affiche ("broadcast symtensor2", test);
    else result *= (test);

  //-----tensor3----------------------------------------------------------------------------------------------------------------------------

  tensor3<long double> tsr3(2,5,9), tsr3_mpi;
  for (int i=1; i<=2; i++)
    for(int j=1; j<=5; j++)
      for (int k=1; k<=9; k++)
	tsr3(i,j,k) = 2*i - j + 3*k;

  tsr3[2] =& mat_mpi;

  if (!myrank) tsr3_mpi = tsr3;
  broadcast(tsr3_mpi,0);

  tests[0] = (tsr3==tsr3_mpi);
  if (myrank) MPI::COMM_WORLD.Isend (tests,1,MPI::INT,0,124);
  else for (int i=1; i<nb_threads; i++)
	 { MPI::COMM_WORLD.Recv (tests,1,MPI::INT,i,124);
	   test *= tests[0];
	 }

  if (!myrank)
    if (detail) affiche ("broadcast tensor3", test);
    else result *= (test);

  //-----tensor4----------------------------------------------------------------------------------------------------------------------------

  tensor4<long double> tsr4(7,2,5,9), tsr4_mpi;
  for (int i=1; i<=7; i++)
    for(int j=1; j<=2; j++)
      for (int k=1; k<=5; k++)
	for (int l=1; l<=9; l++)
	  tsr4(i,j,k,l) = 2*i - j + 3*k*(l-13);

  tsr4[2] =& tsr3_mpi;

  if (!myrank) tsr4_mpi = tsr4;
  broadcast(tsr4_mpi,0);

  tests[0] = (tsr4==tsr4_mpi);
  if (myrank) MPI::COMM_WORLD.Isend (tests,1,MPI::INT,0,124);
  else for (int i=1; i<nb_threads; i++)
	 { MPI::COMM_WORLD.Recv (tests,1,MPI::INT,i,124);
	   test *= tests[0];
	 }

  if (!myrank)
    if (detail) affiche ("broadcast tensor4", test);
    else result *= (test);

  //-----symtensor4-------------------------------------------------------------------------------------------------------------------------

  u = u_mpi;
  symtensor4<long double> stsr4(9,9,7,7), stsr4_mpi;
  for(int i=1; i<=9; i++)
    for (int j=1; j<=9; j++)
      for (int k=1; k<=7; k++)
	for (int l=1; l<=7; l++)
	  stsr4(i,j,k,l) = 5*(i + j) / (k * l);

  if (!myrank) stsr4_mpi = stsr4;
  broadcast(stsr4_mpi,0);

  tests[0] = (stsr4==stsr4_mpi);
  if (myrank) MPI::COMM_WORLD.Isend (tests,1,MPI::INT,0,124);
  else for (int i=1; i<nb_threads; i++)
	 { MPI::COMM_WORLD.Recv (tests,1,MPI::INT,i,124);
	   test *= tests[0];
	 }

  if (!myrank)
    if (detail) affiche ("broadcast symtensor2", test);
    else result *= (test);

  //-----polynom----------------------------------------------------------------------------------------------------------------------------

  polynom<long double> Px(9), Px_mpi;
  Px[0]=2.; Px[2]=7.25; Px[3]=14.67; Px[4]=234.2; Px[5]=0.; Px[6]=0.543378; Px[7]=13.; Px[8]=0.; Px[9]=45.;

  if (!myrank) Px_mpi = Px;
  broadcast (Px_mpi, 0);

  tests[0] = (Px_mpi==Px);
  if (myrank) MPI::COMM_WORLD.Isend (tests,1,MPI::INT,0,123);
  else for (int i=1; i<nb_threads; i++)
	 { MPI::COMM_WORLD.Recv (tests,1,MPI::INT,i,123);
	   test *= tests[0];
	 }

  if (!myrank)
    if (detail) affiche ("broadcast polynom", test);
    else result *= (test);

  //----------------------------------------------------------------------------------------------------------------------------------------

  MPI::COMM_WORLD.Barrier();

  if (!myrank)
    { cout << endl;
      cout << "============================================================== \n";
      if (result) cout << green << "                     broadcast test passed" << reset;
      else cout << red << "                     broadcast test failed" << reset;
      cout << "============================================================== \n";
    }

  return result;
}


#endif
