/* This file is part of the MPFRCPP Library.

   Copyright (c) 2006-2007 Alexey V. Beshenov <bav.272304@gmail.com>.

   The MPFRCPP Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of the
   License, or (at your option) any later version.

   The MPFRCPP Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the MPFRCPP Library; see the file COPYING.LIB. If
   not, write to the Free Software Foundation, Inc., 51 Franklin Street,
   Fifth Floor, Boston, MA 02110-1301, USA. */

/**
 * @file nacre_polynomial_roots.cpp
 * @date 2007-04-xx
 */

#include <nacre/polynomial.hpp>
#include <nacre/rational.hpp>

int main () {

    unsigned int max_order = 10;

    std::cout << "Chebyshev Polynomials" << std::endl;
    for (size_t i = 0; i <= max_order; i++)
        std::cout << "T_"<< i << " = " <<
        nacre::polynomial::ChebyshevPolynomial<nacre::rational::Rational<int> > (i) << std::endl;
    std::cout << std::endl;

    std::cout << "Legendre Polynomials" << std::endl;
    for (size_t i = 0; i <= max_order; i++)
        std::cout << "P_"<< i << " = " <<
        nacre::polynomial::LegendrePolynomial<nacre::rational::Rational<int> > (i) << std::endl;
    std::cout << std::endl;

    std::cout << "Laguerre Polynomials" << std::endl;
    for (size_t i = 0; i <= max_order; i++)
        std::cout << "L_"<< i << " = " <<
        nacre::polynomial::LaguerrePolynomial<nacre::rational::Rational<int> > (i) << std::endl;
    std::cout << std::endl;

    std::cout << "Hermite Polynomials" << std::endl;
    for (size_t i = 0; i <= max_order; i++)
        std::cout << "H_"<< i << " = " <<
        nacre::polynomial::HermitePolynomial<nacre::rational::Rational<int> > (i) << std::endl;
    std::cout << std::endl;

    return 0;
}
