/* This file is part of the MPFRCPP Library.

  Copyright (c) 2006 -- 2007 Alexey V. Beshenov <bav.272304@gmail.com>.

  The MPFRCPP Library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) any later version.

  The MPFRCPP Library is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with the MPFRCPP Library; see the file COPYING.LIB. If
  not, write to the Free Software Foundation, Inc., 51 Franklin Street,
  Fifth Floor, Boston, MA 02110-1301, USA. */

/**
 * @file static_methods.hpp
 * @date 2007-03-23
 * mpfrcpp::Real static methods: getParameters, setParameters, epsilon.
 * INTERNAL HEADER, NOT TO BE USED DIRECTLY.
 */

#ifndef INCLUDED_BY_MPFRCPP
    #error THIS IS AN INTERNAL HEADER ONLY, NOT TO BE USED DIRECTLY
#endif

#ifndef MPFRCPP_REAL_STATIC_METHODS
#define MPFRCPP_REAL_STATIC_METHODS

namespace mpfrcpp {

    //------------------------------------------------------------

    GlobalParameters& Real::getParameters() throw() {
        return params_;
    }

    //------------------------------------------------------------

    void Real::setParameters ( GlobalParameters& params ) throw() {
        params_ = params;
    }

    //------------------------------------------------------------

    /**
     * Machine epsilon,
     * 2^(1-p) for precision p
     */

    Real Real::epsilon ( const Precision& pr ) throw() {
        Real e ( pr );
        mpfr_set_ui_2exp ( e.getMpfrT(), 1, 1 - pr.getMpfrPrecT(),
                           getParameters().getDefaultRoundMode().getMpfrRndT() );
        return e;
    }

    //------------------------------------------------------------

} // namespace mpfrcpp

#endif    // MPFRCPP_REAL_STATIC_METHODS
