// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/libmpak/mpak/builtins/dependency_node_data.cc,v 1.5 2004/07/07 01:54:57 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <config.h>

#include <mpak/builtins/timestamp_node_data.hh>

#include <boost/shared_ptr.hpp>

#include <map>

namespace mpak
{
    namespace builtins
    {
        timestamp_node_data::~timestamp_node_data (void)
        {
        }
        
        timestamp_node_data *
        timestamp_node_data::
        clone (void)
            const
        {
            return new timestamp_node_data (*this);
        }
        
        void
        timestamp_node_data::
        merge (const boost::shared_ptr<node_data> &that_node_data)
            const
        {
            const boost::shared_ptr<timestamp_node_data> that (boost::dynamic_pointer_cast<timestamp_node_data> (that_node_data));
            assert (that);
            
            that->timestamp_ = this->timestamp_;
        }
    }
}
