// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/builtins/timestamp_node_data.hh,v 1.3 2004/07/07 01:54:57 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__BUILTINS__TIMESTAMP_NODE_DATA_HH__
#define __MPAK__BUILTINS__TIMESTAMP_NODE_DATA_HH__

#include <mpak/defs.hh>
#include <mpak/spec/fwd.hh>
#include <mpak/spec/node_data.hh>

#include <sys/time.h>

namespace mpak
{
    namespace builtins
    {
        class timestamp_node_data
            : public spec::node_data
        {
        private:
            struct timeval timestamp_;
            
        public:
            timestamp_node_data (void)
                : spec::node_data (),
                  timestamp_ ()
            {
                this->set_timestamp_now ();
            }
            
        protected:
            timestamp_node_data (const timestamp_node_data &that)
                : spec::node_data (that),
                  timestamp_ (that.timestamp_)
            {
            }
            
        public:
            virtual
            ~timestamp_node_data (void);
            
            virtual timestamp_node_data *
            clone (void)
                const;
            
            void
            merge (const boost::shared_ptr<node_data> &that_node_data)
                const;
            
            const struct timeval &
            get_timestamp (void)
                const
            {
                return this->timestamp_;
            }
            
            void
            set_timestamp (const struct timeval &timestamp)
            {
                this->timestamp_ = timestamp;
            }
            
            void
            set_timestamp_now (void)
            {
                gettimeofday (&this->timestamp_, 0);
            }
        };
    }
}

#endif // ifndef __MPAK__BUILTINS__TIMESTAMP_NODE_DATA_HH__
