// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/builtins/option_node_data.hh,v 1.3 2004/07/07 01:54:57 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__BUILTINS__OPTION_NODE_DATA_HH__
#define __MPAK__BUILTINS__OPTION_NODE_DATA_HH__

#include <mpak/defs.hh>
#include <mpak/spec/fwd.hh>
#include <mpak/spec/node_data.hh>
#include <mpak/util/fwd.hh>

#include <boost/optional.hpp>

#include <string>
#include <set>

namespace mpak
{
    namespace builtins
    {
        class option_node_data
            : public spec::node_data
        {
        private:
            std::set<std::string> flags_;
            
        public:
            option_node_data (void)
                : spec::node_data (),
                  flags_ ()
            {
            }
            
        protected:
            option_node_data (const option_node_data &that)
                : spec::node_data (that),
                  flags_ (that.flags_)
            {
            }
            
        public:
            virtual
            ~option_node_data (void);
            
            virtual option_node_data *
            clone (void)
                const;
            
            void
            merge (const boost::shared_ptr<node_data> &that_node_data)
                const;
            
            void
            add_flag (const std::string &flag)
            {
                this->flags_.insert (flag);
            }
            
            bool
            has_flag (const std::string &flag)
                const
            {
                return this->flags_.find (flag) != this->flags_.end ();
            }
            
            typedef std::set<std::string>::const_iterator flag_iterator;
            
            flag_iterator
            begin_flags (void)
                const
            {
                return this->flags_.begin ();
            }
            
            flag_iterator
            end_flags (void)
                const
            {
                return this->flags_.end ();
            }
            
        };
        
        const boost::shared_ptr<builtins::option_node_data>
        collect_options (const boost::shared_ptr<const spec::node> &root,
                         const util::node_path &node_path,
                         const std::string &node_type,
                         const std::string &node_data_type,
                         bool must_exist);
    }
}

#endif // ifndef __MPAK__BUILTINS__OPTION_NODE_DATA_HH__
