// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/build/stage.hh,v 1.3 2004/07/01 22:45:37 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__BUILD__STAGE_HH__
#define __MPAK__BUILD__STAGE_HH__

#include <mpak/spec/fwd.hh>
#include <mpak/build/fwd.hh>
#include <mpak/builtins/fwd.hh>
#include <mpak/util/node_path.hh>

#include <boost/shared_ptr.hpp>

#include <list>
#include <string>
#include <stdexcept>

namespace mpak
{
    namespace build
    {
        class stage
        {
        public:
            class failure
                : public std::runtime_error
            {
            public:
                inline failure (const std::string &what)
                    : runtime_error (what)
                {
                }
            };
            
            stage (void)
            {
            }
            
            virtual ~stage (void);
            
            virtual bool
            is_complete (const util::node_path &node_path,
                         const boost::shared_ptr<const builtins::version_node> &version_node,
                         const environment &environment)
                const;
            
            virtual void
            execute (const util::node_path &node_path,
                     const boost::shared_ptr<builtins::version_node> &version_node,
                     const environment &environment)
                const = 0;
        };
    }
}

#endif // ifndef __MPAK__BUILD__STAGE_HH__
