// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/build/dependency_calc.hh,v 1.2 2004/07/07 01:54:57 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__BUILD__DEPENDENCY_CALC_HH__
#define __MPAK__BUILD__DEPENDENCY_CALC_HH__

#include <mpak/build/fwd.hh>
#include <mpak/util/fwd.hh>
#include <mpak/util/dependency.hh>

#include <boost/shared_ptr.hpp>

namespace mpak
{
    namespace build
    {
        class dependency_calc
        {
            typedef std::vector<util::dependency> dependency_vector_type_;
            dependency_vector_type_ dependencies_;
            
        public:
            class failure
                : public std::runtime_error
            {
            public:
                inline failure (const std::string &what)
                    : runtime_error (what)
                {
                }
            };
            
            dependency_calc (void)
                : dependencies_ ()
            {
            }
            
            void
            add_dependency (const util::dependency &dependency)
            {
                this->dependencies_.push_back (dependency);
            }
            
            const util::node_path_list
            calculate (const environment &env);
        };
    }
}

#endif // ifndef __MPAK__BUILD__DEPENDENCY_CALC_HH__
