// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/libmpak/mpak/util/dependency_grammar.hh,v 1.3 2004/07/06 17:20:31 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__UTIL__DEPENDENCY_GRAMMAR_HH__
#define __MPAK__UTIL__DEPENDENCY_GRAMMAR_HH__

#include <mpak/util/dependency.hh>
#include <mpak/util/node_path_grammar.hh>
#include <mpak/util/version_spec_grammar.hh>
#include <mpak/spec/node.hh>

#include <boost/spirit.hpp>
#include <boost/spirit/phoenix.hpp>

#include <set>
#include <string>

namespace mpak
{
    namespace util
    {
        namespace detail
        {
            struct options_closure
                : public boost::spirit::closure<options_closure, std::vector<std::string> >
            {
                member1 options;
            };
            
            struct options_grammar
                : public boost::spirit::grammar<options_grammar, options_closure::context_t>
            {
                template<class scanner_type_>
                struct definition
                {
                    typedef boost::spirit::rule<scanner_type_> rule_type;
                    rule_type start_;
                    rule_type option;
                    rule_type slot;
                    node_path_grammar node_path;
                    
                    definition (const options_grammar &self)
                    {
                        using boost::spirit::ch_p;
                        using boost::spirit::str_p;
                        using boost::spirit::epsilon_p;
                        using boost::spirit::space_p;
                        using boost::spirit::anychar_p;
                        using boost::spirit::chset_p;
                        
                        using phoenix::var;
                        using phoenix::bind;
                        using phoenix::arg1;
                        using phoenix::arg2;
                        using phoenix::construct_;
                        
                        start_ =
                            ch_p ('(') >> *space_p >>
                            (option[bind (&std::vector<std::string>::push_back) (self.options, construct_<std::string> (arg1, arg2))] % space_p) >>
                            *space_p >> ch_p (')');
                        option =
                            ( (+chset_p ("A-Za-z0-9_+-."))
                            | (ch_p ('@') >> node_path >> !(str_p ("::") >> +chset_p ("A-Za-z0-9_+-.")))
                            );
                       
                    }
                
                    const boost::spirit::rule<scanner_type_> &
                    start (void) const
                    {
                        return this->start_;
                    }
                };
            };
            
            struct dependency_closure
                : public boost::spirit::closure<dependency_closure, dependency>
            {
                member1 dependency_;
            };
            
            struct dependency_grammar
                : public boost::spirit::grammar<dependency_grammar, dependency_closure::context_t>
            {
                template<class scanner_type_>
                struct definition
                {
                    typedef boost::spirit::rule<scanner_type_> rule_type;
                    rule_type start_;
                    rule_type comparison;
                    rule_type slot;
                    options_grammar options;
                    node_path_grammar path;
                    version_spec_grammar version_spec;
                    
                    definition (const dependency_grammar &self)
                    {
                        using boost::spirit::ch_p;
                        using boost::spirit::str_p;
                        using boost::spirit::epsilon_p;
                        using boost::spirit::space_p;
                        using boost::spirit::anychar_p;
                        using boost::spirit::chset_p;
                        
                        using phoenix::var;
                        using phoenix::bind;
                        using phoenix::arg1;
                        using phoenix::arg2;
                        using phoenix::construct_;
                        
                        start_ = path[bind (&dependency::set_path) (self.dependency_, arg1)] >>
                            !(str_p ("::") >>
                              slot) >>
                            !(*space_p >> options[bind (&dependency::set_options) (self.dependency_, arg1)]) >>
                            !(+space_p >>
                              (comparison) >>
                              +space_p >>
                              version_spec[bind (&dependency::set_version_spec) (self.dependency_, arg1)]);
                        slot =
                            (+chset_p ("A-Za-z0-9_+-."))[bind (&dependency::set_slot) (self.dependency_,
                                                                                       construct_<std::string> (arg1, arg2))];
                        comparison =
                            str_p ("<=")[bind (&dependency::set_compare_type) (self.dependency_, dependency::compare_less_equal)]    |
                            str_p (">=")[bind (&dependency::set_compare_type) (self.dependency_, dependency::compare_greater_equal)] |
                            str_p ("!=")[bind (&dependency::set_compare_type) (self.dependency_, dependency::compare_not_equal)]     |
                            ch_p  ('<') [bind (&dependency::set_compare_type) (self.dependency_, dependency::compare_less)]          |
                            ch_p  ('>') [bind (&dependency::set_compare_type) (self.dependency_, dependency::compare_greater)]       |
                            ch_p  ('=') [bind (&dependency::set_compare_type) (self.dependency_, dependency::compare_equal)];
                    
                        BOOST_SPIRIT_DEBUG_NODE(start_);
                        BOOST_SPIRIT_DEBUG_NODE(slot);
                        BOOST_SPIRIT_DEBUG_NODE(comparison);
                        BOOST_SPIRIT_DEBUG_NODE(path);
                        BOOST_SPIRIT_DEBUG_NODE(version_spec);
                    }
                
                    const boost::spirit::rule<scanner_type_> &
                    start (void) const
                    {
                        return this->start_;
                    }
                };
            };
        }
    }
}

#endif // ifndef __MPAK__UTIL__DEPENDENCY_GRAMMAR_HH__
