// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/libmpak/mpak/builtins/option_node_data.cc,v 1.6 2004/07/07 02:40:42 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <config.h>

#include <mpak/builtins/option_node_data.hh>
#include <mpak/util/node_path.hh>
#include <mpak/spec/node.hh>

namespace mpak
{
    namespace builtins
    {
        option_node_data *
        option_node_data::
        clone (void)
            const
        {
            return new option_node_data (*this);
        }
        
        void
        option_node_data::
        merge (const boost::shared_ptr<node_data> &that_node_data)
            const
        {
            boost::shared_ptr<option_node_data> that (boost::dynamic_pointer_cast<option_node_data> (that_node_data));
            assert (that);
            
            for (std::set<std::string>::const_iterator i (this->flags_.begin ()); i != this->flags_.end (); ++i) {
                that->flags_.insert (*i);
            }
        }
        
        option_node_data::~option_node_data (void)
        {
        }
        
        const boost::shared_ptr<builtins::option_node_data>
        collect_options (const boost::shared_ptr<const spec::node> &root,
                         const util::node_path &node_path,
                         const std::string &node_type,
                         const std::string &node_data_type,
                         bool must_exist)
        {
            unsigned node_type_n; // category == 0, package == 1, version == 2
            if (node_type == "mpak:category") {
                node_type_n = 0;
            } else if (node_type == "mpak:package") {
                node_type_n = 1;
            } else if (node_type == "mpak:version") {
                node_type_n = 2;
            } else {
                assert (false);
            }
            assert (node_type_n <= node_path.elements_size ());
            util::node_path::elements_size_type num_category_elements (node_path.elements_size () - node_type_n);
            
            boost::shared_ptr<builtins::option_node_data> option_node_data;
            if (root->has_data (node_data_type)) {
                boost::shared_ptr<const builtins::option_node_data> temp_option_node_data
                    (boost::dynamic_pointer_cast<const builtins::option_node_data> (root->get_data (node_data_type)));
                assert (temp_option_node_data);
                option_node_data.reset (temp_option_node_data->clone ());
            } else {
                option_node_data.reset (new builtins::option_node_data);
            }
            
            boost::shared_ptr<const spec::node> node (root);
            for (util::node_path::elements_size_type n (0); n < num_category_elements; ++n) {
                if (node->has_child ("mpak:category", node_path.element_at (n))) {
                    node = node->get_child ("mpak:category", node_path.element_at (n));
                } else {
                    if (must_exist) {
                        assert (false);
                    } else {
                        return option_node_data;
                    }
                }
                
                if (node->has_data (node_data_type)) {
                    boost::shared_ptr<const spec::node_data> source_node_data (node->get_data (node_data_type));
                    source_node_data->merge (option_node_data);
                }
            }
            
            if (node_type_n >= 1) { // package_node
                if (node->has_child ("mpak:package", node_path.element_at (num_category_elements))) {
                    node = node->get_child ("mpak:package", node_path.element_at (num_category_elements));
                } else {
                    if (must_exist) {
                        assert (false);
                    } else {
                        return option_node_data;
                    }
                }
                
                if (node->has_data (node_data_type)) {
                    boost::shared_ptr<const spec::node_data> source_node_data (node->get_data (node_data_type));
                    source_node_data->merge (option_node_data);
                }
            }
            
            if (node_type_n >= 2) { // version_node
                if (node->has_child ("mpak:version", node_path.element_at (num_category_elements + 1))) {
                    node = node->get_child ("mpak:version", node_path.element_at (num_category_elements + 1));
                } else {
                    if (must_exist) {
                        assert (false);
                    } else {
                        return option_node_data;
                    }
                }
                
                if (node->has_data (node_data_type)) {
                    boost::shared_ptr<const spec::node_data> source_node_data (node->get_data (node_data_type));
                    source_node_data->merge (option_node_data);
                }
            }
            
        }
        
    }
}
