// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/libmpak/mpak/builtins/installed_node_data.cc,v 1.1 2004/07/01 22:45:37 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <config.h>

#include <mpak/builtins/installed_node_data.hh>

namespace mpak
{
    namespace builtins
    {
        installed_node_data *
        installed_node_data::
        clone (void)
            const
        {
            return new installed_node_data (*this);
        }
        
        void
        installed_node_data::
        merge (const boost::shared_ptr<node_data> &that_node_data)
            const
        {
            boost::shared_ptr<installed_node_data> that (boost::dynamic_pointer_cast<installed_node_data> (that_node_data));
            assert (that);
        }
        
        installed_node_data::~installed_node_data (void)
        {
        }
    }
}
