// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/libmpak/mpak/builtins/commands.hh,v 1.9 2004/07/06 17:20:31 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__BUILTINS__COMMANDS_HH__
#define __MPAK__BUILTINS__COMMANDS_HH__

#include <mpak/spec/fwd.hh>
#include <mpak/spec/command_info.hh>
#include <mpak/builtins/config_node.hh>

#include <boost/optional.hpp>
#include <boost/shared_ptr.hpp>

#include <string>

namespace mpak
{
    namespace builtins
    {
        namespace commands
        {
            boost::optional<std::string>
            mpak                        (const boost::shared_ptr<spec::node> &node,
                                         const boost::shared_ptr<const spec::argument_vector> &arguments,
                                         spec::context &context);
            boost::optional<std::string>
            set                         (const boost::shared_ptr<spec::node> &node,
                                         const boost::shared_ptr<const spec::argument_vector> &arguments,
                                         spec::context &context);
            
            class get
            {
                const boost::shared_ptr<const builtins::mpak_node> config_root_;
                
            public:
                get (const boost::shared_ptr<const builtins::mpak_node> config_root = boost::shared_ptr<const builtins::mpak_node> ())
                    : config_root_ (config_root)
                {
                }
                
                boost::optional<std::string>
                operator () (const boost::shared_ptr<spec::node> &node,
                             const boost::shared_ptr<const spec::argument_vector> &arguments,
                             spec::context &context)
                    const;
            };
            
            boost::optional<std::string>
            if_else                     (const boost::shared_ptr<spec::node> &node,
                                         const boost::shared_ptr<const spec::argument_vector> &arguments,
                                         spec::context &context);
            boost::optional<std::string>
            return_                     (const boost::shared_ptr<spec::node> &node,
                                         const boost::shared_ptr<const spec::argument_vector> &arguments,
                                         spec::context &context);
            boost::optional<std::string>
            concat                      (const boost::shared_ptr<spec::node> &node,
                                         const boost::shared_ptr<const spec::argument_vector> &arguments,
                                         spec::context &context);
            
            namespace tree
            {
                boost::optional<std::string>
                description                 (const boost::shared_ptr<spec::node> &node,
                                             const boost::shared_ptr<const spec::argument_vector> &arguments,
                                             spec::context &context);
                
                boost::optional<std::string>
                slot                        (const boost::shared_ptr<spec::node> &node,
                                             const boost::shared_ptr<const spec::argument_vector> &arguments,
                                             spec::context &context);
                boost::optional<std::string>
                slots                       (const boost::shared_ptr<spec::node> &node,
                                             const boost::shared_ptr<const spec::argument_vector> &arguments,
                                             spec::context &context);
                
                boost::optional<std::string>
                dependency                  (const boost::shared_ptr<spec::node> &node,
                                             const boost::shared_ptr<const spec::argument_vector> &arguments,
                                             spec::context &context);
                
                boost::optional<std::string>
                source                      (const boost::shared_ptr<spec::node> &node,
                                             const boost::shared_ptr<const spec::argument_vector> &arguments,
                                             spec::context &context);
                boost::optional<std::string>
                checksum                    (const boost::shared_ptr<spec::node> &node,
                                             const boost::shared_ptr<const spec::argument_vector> &arguments,
                                             spec::context &context);
                
                boost::optional<std::string>
                script                      (const boost::shared_ptr<spec::node> &node,
                                             const boost::shared_ptr<const spec::argument_vector> &arguments,
                                             spec::context &context);
                boost::optional<std::string>
                interpreter                 (const boost::shared_ptr<spec::node> &node,
                                             const boost::shared_ptr<const spec::argument_vector> &arguments,
                                             spec::context &context);
                
                boost::optional<std::string>
                file_stat                   (const boost::shared_ptr<spec::node> &node,
                                             const boost::shared_ptr<const spec::argument_vector> &arguments,
                                             spec::context &context);
                boost::optional<std::string>
                timestamp                   (const boost::shared_ptr<spec::node> &node,
                                             const boost::shared_ptr<const spec::argument_vector> &arguments,
                                             spec::context &context);
                
                class option
                {
                    const std::string option_type_;
                    
                public:
                    option (const std::string &option_type)
                        : option_type_ (option_type)
                    {
                    }
                    
                    boost::optional<std::string>
                    operator () (const boost::shared_ptr<spec::node> &node,
                                 const boost::shared_ptr<const spec::argument_vector> &arguments,
                                 spec::context &context)
                        const;
                };
                
                class if_option
                {
                    const std::string option_type_;
                    const std::string option_flags_type_;
                    const boost::shared_ptr<const builtins::config_node> config_root_;
                    
                public:
                    if_option (const std::string &option_type,
                               const std::string &option_flags_type,
                               const boost::shared_ptr<const builtins::config_node> config_root)
                        : option_type_ (option_type),
                          option_flags_type_ (option_flags_type),
                          config_root_ (config_root)
                    {
                    }
                    
                    boost::optional<std::string>
                    operator ()             (const boost::shared_ptr<spec::node> &node,
                                             const boost::shared_ptr<const spec::argument_vector> &arguments,
                                             spec::context &context)
                        const;
                };
            }
            
            namespace config
            {
                boost::optional<std::string>
                package_tree_dir            (const boost::shared_ptr<spec::node> &node,
                                             const boost::shared_ptr<const spec::argument_vector> &arguments,
                                             spec::context &context);
                boost::optional<std::string>
                statedb_dir                 (const boost::shared_ptr<spec::node> &node,
                                             const boost::shared_ptr<const spec::argument_vector> &arguments,
                                             spec::context &context);
                boost::optional<std::string>
                mpaktmp_dir                 (const boost::shared_ptr<spec::node> &node,
                                             const boost::shared_ptr<const spec::argument_vector> &arguments,
                                             spec::context &context);
                boost::optional<std::string>
                source_dir                  (const boost::shared_ptr<spec::node> &node,
                                             const boost::shared_ptr<const spec::argument_vector> &arguments,
                                             spec::context &context);
            }
        }
        
        namespace command_gens
        {
            boost::shared_ptr<spec::command_info_list>
            mpak_node_command_gen (const boost::shared_ptr<const spec::node> &node);
            boost::shared_ptr<spec::command_info_list>
            category_node_command_gen (const boost::shared_ptr<const spec::node> &node);
            boost::shared_ptr<spec::command_info_list>
            package_node_command_gen (const boost::shared_ptr<const spec::node> &node);
            boost::shared_ptr<spec::command_info_list>
            version_node_command_gen (const boost::shared_ptr<const spec::node> &node);
            
            boost::shared_ptr<spec::command_info_list>
            dependency_node_data_command_gen (const boost::shared_ptr<const spec::node_data> &node_data);
            boost::shared_ptr<spec::command_info_list>
            timestamp_node_data_command_gen (const boost::shared_ptr<const spec::node_data> &node_data);
            boost::shared_ptr<spec::command_info_list>
            installed_node_data_command_gen (const boost::shared_ptr<const spec::node_data> &node_data);
            
            class option_node_data_command_gen
            {
                const std::string command_name_;
            public:
                option_node_data_command_gen (const std::string &command_name)
                    : command_name_ (command_name)
                {
                }
                
                boost::shared_ptr<spec::command_info_list>
                operator () (const boost::shared_ptr<const spec::node_data> &node_data)
                    const;
            };
            
            boost::shared_ptr<spec::command_info_list>
            script_node_data_command_gen (const boost::shared_ptr<const spec::node_data> &node_data);
            boost::shared_ptr<spec::command_info_list>
            sources_node_data_command_gen (const boost::shared_ptr<const spec::node_data> &node_data);
            boost::shared_ptr<spec::command_info_list>
            installed_node_data_command_gen (const boost::shared_ptr<const spec::node_data> &node_data);
        }
    }
}

#endif // ifndef __MPAK__COMMANDS__COMMANDS_HH__
