// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/spec/node_data.hh,v 1.4 2004/07/01 22:45:37 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__SPEC__NODE_DATA_HH__
#define __MPAK__SPEC__NODE_DATA_HH__

#include <mpak/defs.hh>
#include <mpak/spec/fwd.hh>

#include <boost/utility.hpp>
#include <boost/weak_ptr.hpp>
#include <boost/optional.hpp>

#include <stdexcept>

namespace mpak
{
    namespace spec
    {
        class node_data
            : boost::noncopyable
        {
            friend class context;
            friend class node;
            
        public:
            class failure
                : public std::runtime_error
            {
            public:
                inline failure (const std::string &what)
                    : runtime_error (what)
                {
                }
            };
            
        public:
            node_data ()
            {
            }
            
        protected:
            node_data (const node_data &that)
            {
            }
            
        public:
            virtual node_data *
            clone (void)
                const = 0;
            
            virtual void
            merge (const boost::shared_ptr<node_data> &that)
                const;
            
        public:
            virtual
            ~node_data (void);
        };
    }
}

#endif // ifndef __MPAK__SPEC__NODE_HH__
