// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/builtins/version_node.hh,v 1.1 2004/07/01 22:45:37 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__BUILTINS__VERSION_NODE_HH__
#define __MPAK__BUILTINS__VERSION_NODE_HH__

#include <mpak/defs.hh>
#include <mpak/spec/node.hh>
#include <mpak/builtins/mpak_node.hh>
#include <mpak/util/version_spec.hh>

#include <boost/weak_ptr.hpp>
#include <boost/optional.hpp>

#include <string>

namespace mpak
{
    namespace builtins
    {
        class version_node
            : public mpak_node
        {
            mutable boost::optional<std::string> slot_;
            const util::version_spec spec_;
            
        public:
            version_node (const std::string &type, const std::string &name,
                          spec::context &context,
                          const bool serialized_init = false)
                : mpak_node (type, name, context, serialized_init),
                  slot_ (),
                  spec_ (name)
            {
            }
            
            virtual
            ~version_node (void);
            
            const boost::optional<std::string> &
            get_slot (void)
                const
            {
                this->init ();
                return this->slot_;
            }
            
            void
            set_slot (const boost::optional<std::string> &slot)
            {
                this->slot_ = slot;
            }
            
            const util::version_spec &
            get_spec (void)
                const
            {
                return this->spec_;
            }
        };
    }
}

#endif // ifndef __MPAK__BUILTINS__VERSION_NODE_HH__
