// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/builtins/package_node.hh,v 1.1 2004/07/01 22:45:37 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__BUILTINS__PACKAGE_NODE_HH__
#define __MPAK__BUILTINS__PACKAGE_NODE_HH__

#include <mpak/defs.hh>
#include <mpak/spec/node.hh>
#include <mpak/builtins/mpak_node.hh>
#include <mpak/spec/fwd.hh>

#include <boost/weak_ptr.hpp>

#include <string>
#include <set>

namespace mpak
{
    namespace builtins
    {
        class package_node
            : public mpak_node
        {
            typedef std::set<std::string> slot_set_type_;
            mutable slot_set_type_ slots_;
            
        public:
            package_node (const std::string &type, const std::string &name,
                          spec::context &context,
                          const bool serialized_init = false)
                : mpak_node (type, name, context, serialized_init),
                  slots_ ()
            {
            }
            
            virtual
            ~package_node (void);
            
            void
            add_slot (const std::string &slot)
            {
                if (!this->slots_.insert (slot).second)
                    throw failure ("could not insert slot: " + slot);
            }
            
            bool
            has_slot (const std::string &slot)
                const
            {
                return this->slots_.find (slot) != this->slots_.end ();
            }
            
            bool
            has_slots (void)
                const
            {
                this->init ();
                return !this->slots_.empty ();
            }
            
            typedef slot_set_type_::const_iterator slot_iterator;
            
            slot_iterator
            begin_slots (void)
                const
            {
                this->init ();
                return this->slots_.begin ();
            }
            
            slot_iterator
            end_slots (void)
                const
            {
                this->init ();
                return this->slots_.end ();
            }
        };
    }
}

#endif // ifndef __MPAK__BUILTINS__PACKAGE_NODE_HH__
