// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/builtins/mpak_node.hh,v 1.1 2004/07/01 22:45:37 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__BUILTINS__MPAK_NODE_HH__
#define __MPAK__BUILTINS__MPAK_NODE_HH__

#include <mpak/defs.hh>
#include <mpak/spec/fwd.hh>
#include <mpak/spec/node.hh>

#include <boost/weak_ptr.hpp>
#include <boost/optional.hpp>
#include <boost/utility.hpp>

#include <string>
#include <map>

namespace mpak
{
    namespace builtins
    {
        class mpak_node
            : public spec::node
        {
        private:
            typedef std::map<std::string, std::string> env_map_type_;
            mutable env_map_type_ env_map_;
            mutable std::string description_;
            
        public:
            mpak_node (const std::string &type, const std::string &name,
                       spec::context &context,
                       const bool serialized_init = false)
                : spec::node (type, name, context, serialized_init),
                  env_map_ (),
                  description_ ()
            {
            }
            
        public:
            virtual
            ~mpak_node (void);
            
            typedef env_map_type_::const_iterator env_iterator;
            
            env_iterator
            begin_env (void)
                const
            {
                this->init ();
                return this->env_map_.begin ();
            }
            
            env_iterator
            end_env (void)
                const
            {
                this->init ();
                return this->env_map_.end ();
            }
            
            inline bool has_env (const std::string &key)
                const
            {
                this->init ();
                return (this->env_map_.find (key) != this->env_map_.end ());
            }
            
            boost::optional<std::string>
            get_env (const std::string &key)
                const;
            
            inline void
            set_env (const std::string &key, const std::string &value)
            {
                this->init ();
                this->env_map_[key] = value;
            }
            
            inline const std::string &
            get_description (void)
                const
            {
                this->init ();
                return this->description_;
            }
            
            inline void
            set_description (const std::string &description)
            {
                this->init ();
                this->description_ = description;
            }
        };
    }
}

#endif // ifndef __MPAK__BUILTINS__MPAK_NODE_HH__
