// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/builtins/installed_node_data.hh,v 1.2 2004/07/06 17:20:31 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__BUILTINS__INSTALLED_NODE_DATA_HH__
#define __MPAK__BUILTINS__INSTALLED_NODE_DATA_HH__

#include <mpak/defs.hh>
#include <mpak/spec/node_data.hh>
#include <mpak/util/file_stat.hh>
#include <mpak/util/checksummer.hh>

#include <boost/filesystem/path.hpp>

#include <string>
#include <map>

namespace mpak
{
    namespace builtins
    {
        class installed_node_data
            : public spec::node_data
        {
            struct file_stat_map_sort
            {
                bool
                operator () (const boost::filesystem::path &path1, const boost::filesystem::path &path2)
                    const
                {
                    return path1.string () < path2.string ();
                }
            };
            
            typedef std::map<boost::filesystem::path, util::file_stat, file_stat_map_sort> file_stat_map_type_;
            file_stat_map_type_ file_stat_map_;
            
        public:
            installed_node_data (void)
                : spec::node_data (),
                  file_stat_map_ ()
            {
            }
            
        protected:
            installed_node_data (const installed_node_data &that)
                : spec::node_data (that),
                  file_stat_map_ (that.file_stat_map_)
            {
            }
            
        public:
            typedef file_stat_map_type_::const_iterator file_stat_iterator;
            
            virtual
            ~installed_node_data (void);
            
            virtual installed_node_data *
            clone (void)
                const;
            
            virtual void
            merge (const boost::shared_ptr<spec::node_data> &that)
                const;
            
            void
            add_file_stat (const boost::filesystem::path &path, const util::file_stat &file_stat)
            {
                if (!this->file_stat_map_.insert (file_stat_map_type_::value_type (path, file_stat)).second)
                    throw failure ("already have stats for file " + (path).native_file_string ());
            }
            
            const util::file_stat &
            get_file_stat (const boost::filesystem::path &path)
                const
            {
                file_stat_map_type_::const_iterator i (this->file_stat_map_.find (path));
                if (i == this->file_stat_map_.end ()) {
                    throw failure ("could not find stats for file " + path.native_file_string ());
                }
                return i->second;
            }
            
            file_stat_iterator
            begin_file_stats (void)
                const
            {
                return this->file_stat_map_.begin ();
            }
            
            file_stat_iterator
            end_file_stats (void)
                const
            {
                return this->file_stat_map_.end ();
            }
        };
    }
}

#endif // ifndef __MPAK__BUILTINS__INSTALLED_NODE_DATA_HH__
