// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/build/manager.hh,v 1.4 2004/07/01 22:45:37 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__BUILD__MANAGER_HH__
#define __MPAK__BUILD__MANAGER_HH__

#include <mpak/build/fwd.hh>
#include <mpak/builtins/fwd.hh>
#include <mpak/util/node_path.hh>

#include <boost/shared_ptr.hpp>

#include <string>
#include <map>
#include <stdexcept>

namespace mpak
{
    namespace build
    {
        class manager
        {
        public:
            class failure
                : public std::runtime_error
            {
            public:
                inline failure (const std::string &what)
                    : runtime_error (what)
                {
                }
            };
            
            enum stage_flags {
                stage_use_package_tree,
                stage_use_installed_tree,
                stage_default = stage_use_package_tree,
            };
            
        private:
            typedef std::map<std::string, std::pair<boost::shared_ptr<const stage>, stage_flags> > stage_map_type_;
            stage_map_type_ stage_map_;
            typedef std::multimap<std::string, std::string> dependency_map_type_;
            dependency_map_type_ dependency_map_;
            
        public:
            void add_stage (const std::string &name, const boost::shared_ptr<const stage> &stage,
                            stage_flags flags = stage_default)
            {
                if (!this->stage_map_.insert (stage_map_type_::value_type (name,
                                                                           std::make_pair (stage, flags))).second)
                    throw std::logic_error ("stage " + name + " already exists");
            }
            
            void add_dependency (const std::string &from, const std::string &to)
            {
                assert (this->stage_map_.find (from) != this->stage_map_.end ());
                assert (this->stage_map_.find (to) != this->stage_map_.end ());
                this->dependency_map_.insert (dependency_map_type_::value_type (from, to));
            }
            
            void execute_stage (const std::string &name,
                                const util::node_path &node_path,
                                const environment &env)
                const;
        };
    }
}

#endif // ifndef __MPAK__BUILD__MANAGER_HH__
