//  Copyright (C) 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef MOUSEGRAPH_WINDOW_H
#define MOUSEGRAPH_WINDOW_H

#include <sigc++/signal.h>
#include <sigc++/trackable.h>
#include <gtkmm.h>

class MouseGraphWindow: public sigc::trackable
{
 public:
    MouseGraphWindow(Glib::ustring load_filename = "");
    ~MouseGraphWindow();

    Gtk::Window &get_window() { return *window; }
    void show() {window->show();};
    void hide() {window->hide();};

 private:
    Gtk::Window* window;
    Gtk::Switch *switch_button;
    Gtk::Image *image;
    Gtk::Label *label;

    void update_label();
    void update_image();

    //callbacks
    bool on_delete_event(GdkEventAny *e);
    bool on_window_closed(GdkEventAny*);
    void on_button_clicked();
};

#endif
