//  Copyright (C) 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <config.h>

#include <sigc++/functors/mem_fun.h>
#include <gtkmm.h>
#include "mousegraph-window.h"
#include "main.h"

MouseGraphWindow::MouseGraphWindow(Glib::ustring load_filename)
{
    Glib::RefPtr<Gtk::Builder> xml
	= Gtk::Builder::create_from_file(Main::get_data_path() +
                                         "/glade/mousegraph-window.ui");

    xml->get_widget("window", window);
    window->signal_delete_event().connect
      (sigc::mem_fun(*this, &MouseGraphWindow::on_window_closed));

    xml->get_widget("image", image);
    xml->get_widget("label", label);
    xml->get_widget("switch", switch_button);
    switch_button->property_active().signal_changed().connect(sigc::mem_fun(*this, &MouseGraphWindow::on_button_clicked)); 
    update_label();
    update_image();
}

void MouseGraphWindow::update_image()
{
  if (switch_button->get_active() == true)
    image->set(Main::get_data_path() + "/data/mouse-graph-recording.png");
  else
    image->set(Main::get_data_path() + "/data/mouse-graph.png");
}

void MouseGraphWindow::update_label()
{
  if (switch_button->get_active() == true)
    label->set_text("Turn off to see a picture of your mouse movements.");
  else
    label->set_text("Turn on to begin recording your mouse movements.");
}

MouseGraphWindow::~MouseGraphWindow()
{
  delete window;
}

bool MouseGraphWindow::on_delete_event(GdkEventAny *e)
{
  hide();
  return true;
}

bool MouseGraphWindow::on_window_closed(GdkEventAny*)
{
  return false;
}
      
void MouseGraphWindow::on_button_clicked()
{
  Main::instance().toggle_mouse_graphing();
  update_label();
  update_image();
}
