//  Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef MOUSE_GRAPH_H
#define MOUSE_GRAPH_H

#include <sigc++/sigc++.h>
#include <memory>
#include <gtkmm.h>
#include <gdkmm.h>

struct mousepoint
{
  int x;
  int y;
  Gdk::ModifierType mask;
};

class MouseGraph
{
 public:
    static MouseGraph* create();

    virtual ~MouseGraph();
    void stop_polling();
    void start_polling();
    void toggle_polling();
    bool is_graphing();
    void graph_it();

    //signals
    sigc::signal<void, Cairo::RefPtr<Cairo::ImageSurface> > graphed;

 protected:
    MouseGraph();
 private:
    Cairo::RefPtr<Cairo::ImageSurface> pixmap;
    Cairo::RefPtr<Cairo::Context> cairo;
    sigc::connection poll_timer;
    sigc::connection draw_timer;
  
    int prev_x;
    int prev_y; //where it was
    int prev_mask;
    int prev_button_pressed;

    bool poll();
    int is_button_pressed(Gdk::ModifierType &mask);

    bool draw_points();
    void draw_point(struct mousepoint *point);
    void draw (int x1, int y1, Gdk::ModifierType &mask);
    void draw_line(int x1, int y1);
    void draw_circle(int x1, int y1);
    std::list<struct mousepoint> points;
};

#endif // MOUSE_GRAPH_H
