//  Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef MOUSE_GRAPH_H
#define MOUSE_GRAPH_H

#include <sigc++/sigc++.h>
#include <memory>
#include <gtkmm.h>
#include <gdkmm.h>

class MouseGraph
{
 public:
    static MouseGraph* create();

    virtual ~MouseGraph();
    void stop_polling();
    void start_polling();
    void toggle_polling();
    bool is_graphing();
    void graph_it();

    //signals
    sigc::signal<void, Glib::RefPtr<Gdk::Pixbuf> > graphed;

 protected:
    MouseGraph();
 private:
    Glib::RefPtr<Gdk::Pixmap> pixmap;
    Cairo::RefPtr<Cairo::Context> cairo;
    sigc::connection timer;
  
    Gdk::ModifierType mask;
    int x;
    int y; //where the mouse is
    int button_pressed;
    int prev_x;
    int prev_y; //where it was
    int prev_button_pressed;

    bool poll();
    int is_button_pressed();
};

#endif // MOUSE_GRAPH_H
