//  Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <config.h>

#include <glibmm.h>
#include "main.h"
#include "mouse-graph.h"
#include "timing.h"
#include "ucompose.hpp"

MouseGraph* MouseGraph::create()
{
  return new MouseGraph();
}
MouseGraph::MouseGraph()
{
}
void MouseGraph::start_polling()
{
  pixmap = Gdk::Pixmap::create
    (Gdk::Window::get_default_root_window(),
     Gdk::Display::get_default()->get_default_screen()->get_width(),
     Gdk::Display::get_default()->get_default_screen()->get_height() );
  cairo = pixmap->create_cairo_context();
  cairo->set_source_rgb (1.0, 1.0, 1.0);
  cairo->rectangle(0, 0,
                   Gdk::Display::get_default()->get_default_screen()->get_width(),
                   Gdk::Display::get_default()->get_default_screen()->get_height() );
    cairo->paint();
  Gdk::Window::get_default_root_window()->get_pointer(x, y, mask);
  cairo->move_to(x, y);
  cairo->set_source_rgb (0, 0, 0);
  cairo->set_line_width(1.00);
  timer = Timing::instance().register_timer
    (sigc::mem_fun(this, &MouseGraph::poll), 100);
    

}

void MouseGraph::stop_polling()
{
  int w= 0, h= 0;
  cairo->stroke();
  cairo.clear();
  pixmap->get_size(w, h);
  graphed.emit(Gdk::Pixbuf::create(Glib::RefPtr<Gdk::Drawable>(pixmap), 0, 0, w, h));
  timer.disconnect();
}

int MouseGraph::is_button_pressed()
{
  if (mask & Gdk::BUTTON1_MASK ||
      mask & Gdk::BUTTON2_MASK ||
      mask & Gdk::BUTTON2_MASK ||
      mask & Gdk::BUTTON3_MASK ||
      mask & Gdk::BUTTON4_MASK ||
      mask & Gdk::BUTTON5_MASK)
    return 1;
  return 0;
}

bool MouseGraph::poll()
{
  Gdk::Window::get_default_root_window()->get_pointer(x, y, mask);
  if (x == prev_x && y == prev_y)
    return Timing::CONTINUE;
  prev_x = x;
  prev_y = y;
  cairo->line_to(x, y);
  button_pressed = is_button_pressed();
  if (button_pressed != prev_button_pressed)
    {
      if (rand() % 10 == 0)
        cairo->arc(x, y, rand() %100 , 0, 2.0 * M_PI);
      else if (rand() % 20 == 0)
        cairo->arc(x, y, rand() %1000 , 0, 2.0 * M_PI);
      else
        cairo->arc(x, y, rand() %10 , 0, 2.0 * M_PI);
    }
  prev_button_pressed = button_pressed;
  return Timing::CONTINUE;
}

MouseGraph::~MouseGraph()
{
}

void MouseGraph::toggle_polling()
{
  if (timer.connected())
    stop_polling();
  else
    start_polling();
}

bool MouseGraph::is_graphing()
{
  if (timer.connected())
    return true;
  else
    return false;
}

void MouseGraph::graph_it()
{
  int w= 0, h= 0;
  cairo->stroke();
  pixmap->get_size(w, h);
  graphed.emit(Gdk::Pixbuf::create(Glib::RefPtr<Gdk::Drawable>(pixmap), 0, 0, w, h));
}

