/***************************************************************
 *                 Mathematical Object Library                 *
 *class symtensor2:declarations for 2nd order symmetric tensors*
 *                    simula.plus@cemes.fr                     *
 *		     GNU/linux version 3.2.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2006,2007,2008,2009,2010,2012 COLLARD Christophe
 * copyright © 2006,2007,2008,2009,2010,2012 Centre National de la Recherche Scientifique
 * copyright © 2006,2007,2008,2009,2010 Arts et Métiers ParisTech
 * copyright © 2006,2007 Université de Valenciennes et du Hainaut Cambrésis
 * copyright © 2006,2007,2008,2009,2010 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2006,2007 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*! \namespace mol
    \brief Mathematical Object Libraries
*/

/*! \class mol::symtensor2
    \brief 2nd order symmetric tensor library \n

    \htmlonly 
    <FONT color="#838383">

    symtensor2 belongs to Mathematical Object Libraries (MOL++) </br>
    MOL++ is part of Simula+ <br><br>

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version. <br><br>

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details. <br><br>

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    </FONT>
    \endhtmlonly

    Let \f$ E \f$ be a Euclidean space of dimension \f$ n \f$ with basis vectors \f$ \{ e_i \} = (e_1,\ldots,e_n) \f$. A \f$ 2^\text{nd} \f$ order Euclidean tensor \f$ T \f$ is defined as a bilinear application from \f$ E \times E \longrightarrow \mathbb{R} \f$. We use a matrix storage for these tensors. All the basic operations are then already defined, so we just add some specific tensors operators to this class. \n

    \author copyright \htmlonly &#169; \endhtmlonly 2006, 2007, 2008, 2009, 2010, 2012 Christophe COLLARD \n
            copyright \htmlonly &#169; 2006, 2007, 2008, 2009, 2010, 2012 Centre National de la Recherche Scientifique \endhtmlonly \n
	    copyright \htmlonly &#169; 2006, 2007, 2008, 2009, 2010 Arts et M&#233;tiers ParisTech \endhtmlonly \n
	    copyright \htmlonly &#169; 2006, 2007 Universit&#233; de Valenciennes et du Hainaut Cambr&#233;sis \endhtmlonly \n
	    copyright \htmlonly &#169; 2006, 2007, 2008, 2009, 2010 Laboratoire de Physique et M&#233;canique des Mat&#233;riaux (LPMM - CNRS) \endhtmlonly \n
	    copyright \htmlonly &#169; 2006, 2007 Laboratoire de Math&#233;matiques et ses Applications de Valenciennes (LAMAV) \endhtmlonly \n
	    copyright \htmlonly &#169; 2012 Centre d'Elaboration de Mat&#233;riaux et d'Etudes Structurales (CEMES - CNRS) \endhtmlonly \n
    \version 3.2.0
    \date 2006-2012
    \bug none
    \warning none
*/

#ifndef __cplusplus
#error Must use C++ for the type symtensor2
#endif

#ifndef __symtensors2_hpp
#define __symtensors2_hpp


#ifndef __vectors_hpp
#include "vectors.hpp"
#endif

#ifndef __symmatrix_hpp
#include "symmatrix.hpp"
#endif

#ifndef __tensors2_hpp
#include "tensors2.hpp"
#endif

using namespace std;

namespace mol
{


//==================================================================================
template <class T> class symtensor2 : public symmatrix<T>, public virtual tensor2<T>
//==================================================================================
{
  public:
    symtensor2 () : symmatrix<T> () {}  // default constructor
    symtensor2 (int i, bool init=true, T value=0) : symmatrix<T> (i, i, init, value) {}         // this constructor allocates memory
    symtensor2 (int i, int j, bool init=true, T value=0) : symmatrix<T> (i, j, init, value) {}  // this constructor allocates memory
    symtensor2 (const matrix<T>& mat) : symmatrix<T> (mat) {}       // cast constructor (converts matrix    -> symtensor2)
    symtensor2 (const symmatrix<T>& smat)  : symmatrix<T> (smat) {} // cast constructor (converts symmatrix -> symtensor2)
    symtensor2 (const tensor2<T>& tsr);                             // cast constructor (converts tensor2   -> symtensor2)
    symtensor2 (const symtensor2<T>& stsr) : symmatrix<T> (stsr) {} // copy constructor
    symtensor2 (symtensor2<T>* st)  : symmatrix<T>(st) {}           // copy constructor for temporary objects
    symtensor2 (symmatrix<T>* smat) : symmatrix<T>(smat) {}         // copy constructor for temporary objects
    ~symtensor2 (){}        // destructor
};

//=====Private methods for symtensor2==========================================

//=====Public methods for symtensor2===========================================


/*!
  \brief  Convertion for \f$ 2^\text{nd} \f$ order tensors : tensor2 -> symtensor2.

  Checks that \f$ T \f$  is symmetric and stores its symmetric part into a symtensor object.

  \param tsr \f$ 2^\text{nd} \f$ order tensor \f$ T \f$
*/

//------------------------------------------------------------------
template <class T> symtensor2<T>::symtensor2 (const tensor2<T>& tsr) : symmatrix<T> (tsr.Rows(), tsr.Columns(), false)
//------------------------------------------------------------------
{
  for (int i=1; i<=tsr.Rows(); i++)
    for (int j=1; j<=i; j++)
      { assert (abs(tsr(i,j)-tsr(j,i))<epsilon); // needed by symtensor2 = tensor2
	(*this)(i,j) = tsr(i,j);
      }
}


}


#endif
