/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *                   GNU/linux version 3.0.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2005,2006,2007,2008,2009,2012 COLLARD Christophe
 * copyright © 2005,2006,2007,2008,2009,2012 Centre National de la Recherche Scientifique
 * copyright © 2005,2006,2007,2008,2009 Arts et Métiers ParisTech
 * copyright © 2005,2006,2007 Université de Valenciennes et du Hainaut-Cambrésis
 * copyright © 2005,2006,2007,2008,2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2005,2006,2007 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    legendre-test belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for Legendre-test
#endif

#ifndef __legendre_test_hpp
#define __legendre_test_hpp


#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

#ifndef __vectors_hpp
#include "MOL++/vectors.hpp"
#endif

#ifndef __polynoms_hpp
#include "MOL++/polynoms.hpp"
#endif

#ifndef __legendre_hpp
#include "MOL++/legendre.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace mol;


//============================
int test_legendre (int detail)
//============================
{
  int result=1;
  polynom<long double> P(4), Q(3), dP, dQ;
  Legendre<long double> L4(4), L3(3);

  P[4] = 35./8.;
  P[2] = -15./4;
  P[0] = 3./8.;

  Q[3] = 5./2.;
  Q[1] = -3./2.;

  dP = P.D_dx();
  dQ = Q.D_dx();

  bool test=true;
  for (long double i=-0.9; i<=0.9 && test; i+=0.1)
    { test *= ( abs(L4(i)- P(i))<epsilon && abs(L4.d_dx(i)-dP(i))<epsilon );
      test *= ( abs(L3(i)-Q(i))<epsilon && abs(L3.d_dx(i)-dQ(i))<epsilon );
    }
  if (detail) affiche ("operator () and d_dx()", test);
  else result *= test;

  cout << endl;  

  cout << "============================================================== \n";
  if (result) cout << green << "                     Legendre test passed" << reset;
  else cout << red << "                     Legendre test failed" << reset;
  cout << "============================================================== \n";
  return result;
}



#endif
