/***************************************************************
 * class color : declaration for colors in ANSI VT100 terminal *
 *                    simula.plus@cemes.fr                     *
 *	             GNU/linux version 3.0.0	               *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2009,2012 COLLARD Christophe
 * copyright © 2009,2012 Centre National de la Recherche Scientifique
 * copyright © 2009 Arts et Métiers ParisTech
 * copyright © 2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*! \brief Standard Object Libraries
*/

/*! \brief color library for standard output in ANSI VT100 terminal \n

    \htmlonly 
    <FONT color="#838383">

    colors belongs to Simula+ <br><br>

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version. <br><br>

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details. <br><br>

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    </FONT>
    \endhtmlonly

    Foreground colors are: black, red, green, yellow, blue, magenta, cyan, white. \n
    Background colors are: bg_black, bg_red, bg_green, bg_yellow, bg_blue, bg_magenta, bg_cyan, bg_white. \n
    Combinations may be used. For example: cout << red << bg_black << "Hello world !"; \n
    In order to reset all attributes use the keyword "reset". \n

    \authors copyright \htmlonly &#169; \endhtmlonly 2009, 2012 Christophe COLLARD \n
             copyright \htmlonly &#169; 2009, 2012 Centre National de la Recherche Scientifique \endhtmlonly \n
	     copyright \htmlonly &#169; 2009 Arts et M&#233;tiers ParisTech \endhtmlonly \n
	     copyright \htmlonly &#169; 2009 Laboratoire de Physique et M&#233;canique des Mat&#233;riaux (LPMM - CNRS) \endhtmlonly \n
	     copyright \htmlonly &#169; 2012 Centre d'Elaboration de Mat&#233;riaux et d'Etudes Structurales (CEMES - CNRS) \endhtmlonly \n
    \version 3.0.0
    \date 2009-2012
    \bug none
    \warning none
*/

#ifndef __cplusplus
#error Must use C++ for the type vector
#endif

#ifndef __colors_hpp
#define __colors_hpp

#ifndef __iostream
#include <iostream>
#endif

using namespace std;

//--------------------------------
inline ostream& reset (ostream& s)
//--------------------------------
{
  s << endl << "\033[0m";
  return s;
}


//--------------------------------
inline ostream& black (ostream& s)
//--------------------------------
{
  s << "\033[1;30m";
  return s;
}


//------------------------------
inline ostream& red (ostream& s)
//------------------------------
{
  s << "\033[1;31m";
  return s;
}


//--------------------------------
inline ostream& green (ostream& s)
//--------------------------------
{
  s << "\033[1;32m";
  return s;
}


//---------------------------------
inline ostream& yellow (ostream& s)
//---------------------------------
{
  s << "\033[1;33m";
  return s;
}


//-------------------------------
inline ostream& blue (ostream& s)
//-------------------------------
{
  s << "\033[1;34m";
  return s;
}

 
//----------------------------------
inline ostream& magenta (ostream& s)
//----------------------------------
{
  s << "\033[1;35m";
  return s;
}


//-------------------------------
inline ostream& cyan (ostream& s)
//-------------------------------
{
  s << "\033[1;36m";
  return s;
}


//--------------------------------
inline ostream& white (ostream& s)
//--------------------------------
{
  s << "\033[1;37m";
  return s;
}


//-----------------------------------
inline ostream& bg_black (ostream& s)
//-----------------------------------
{
  s << "\033[1;40m";
  return s;
}


//---------------------------------
inline ostream& bg_red (ostream& s)
//---------------------------------
{
  s << "\033[1;41m";
  return s;
}


//-----------------------------------
inline ostream& bg_green (ostream& s)
//-----------------------------------
{
  s << "\033[1;42m";
  return s;
}


//------------------------------------
inline ostream& bg_yellow (ostream& s)
//------------------------------------
{
  s << "\033[1;43m";
  return s;
}


//----------------------------------
inline ostream& bg_blue (ostream& s)
//----------------------------------
{
  s << "\033[1;44m";
  return s;
}


//-------------------------------------
inline ostream& bg_magenta (ostream& s)
//-------------------------------------
{
  s << "\033[1;45m";
  return s;
}


//----------------------------------
inline ostream& bg_cyan (ostream& s)
//----------------------------------
{
  s << "\033[1;46m";
  return s;
}


//-----------------------------------
inline ostream& bg_white (ostream& s)
//-----------------------------------
{
  s << "\033[1;47m";
  return s;
}


//--------------------------------
inline ostream& clear (ostream& s)
//--------------------------------
{
  s << "\033[2J" << "\033[H";
  return s;
}


#endif
