/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *	             GNU/linux version 0.3.2                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2004,2005,2006 COLLARD Christophe
 * copyright  2004,2005,2006 Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  2004,2005,2006 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    tensors2-test belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for tensors2-test
#endif

#if !defined (__TENSORS2_TEST_H)
#define _tensors2_test_h


#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined (__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__VECTORS_H)
#include "../../MOL++/vectors.h"
#endif

#if !defined(__TENSORS2_H)
#include "../../MOL++/tensors2.h"
#endif

#if !defined(__AFFICHE_h)
#include "../affiche.h"
#endif


//===========================
int test_tensor2 (int detail)
//===========================
{
  int result=1;
  vector<double> u(9), v(9), w(9);

  double reel=2.;
  vector<double> b(9);

  v[1] = 4 ;
  v[2] = -1 ;
  v[4] = -7;
  v[5] = -1 ;
  v[7] = 2;
  v[8] = 12;
  v[9] = 1.25;

  tensor2<double> a(9,9) , c, d, e(9,9), f(9,9), g(9,9),h(9,9), Id(9,9);

  if (detail) affiche ("operator !", !(!a) && !c);
  else result *= (!(!a) && !c);

  tensor2<double> nca(9,4),ncb(9,4), ncc, ncd, ncf(9,4), cna(4,9), cnb;

  for (int i=1; i<=9; i++)
    for (int j=1; j<=4; j++)
      cna(j,i) = nca(i,j) = ncb(i,j) = i*i+2*j;
  cnb = cna;
  ncd = nca;

  for (int i=1; i<=9; i++)
    for (int j=1; j<=i; j++)
      { a(i,j) = 3*i/(2.*j) - 2*i*j;
        a(j,i) = 2*i - 3*j;
	g(i,j) = 2*i/(1.*j);
	g(j,i) = j-2*i;
      }

  for (int i=1; i<=9; i++)
    for (int j=1; j<=9; j++)
      e(i,j) = a(i,j);

  e(2,4) = 0;
  ncb(5,2)=0;

  v[1]=-5; v[2]=24; v[3]=18; v[4]=27; v[5]=-13; v[6]=-1; v[7]=-11; v[8]=-10; v[9]=4;

  for (int i=1; i<=9; i++) Id(i,i)=1;

  if (detail) affiche ("operator ==", a==a && !(a==e) && nca==nca && !(nca==ncb));
  else result *= (a==a && !(a==e) && nca==nca && !(nca==ncb));

  tensor2<long double> mtc(7,7), mtc2(7,7,true,-4.32), mtc3(7), mtc4(7,true,-4.32);
  for (int i=1; i<=7; i++)
    for (int j=1; j<=7; j++)
      mtc(i,j) = mtc3(i,j) = -4.32;
  if (detail) affiche ("constructor", mtc==mtc2 && mtc==mtc3 && mtc==mtc4);
  else result *= mtc==mtc2 && mtc==mtc3 && mtc==mtc4;

  if (detail) affiche ("operator !=", a!=e && nca!=ncb);
  else result *= a!=e && nca!=ncb;

  d=a; e=a; ncc=nca;
  if (detail) affiche ("operator =", a==d && e==a && nca==ncc);
  else result *= (a==d && e==a && nca==ncc);

  tensor2<double> mtx(9,7), mtx2, mtx3(9,7), mtx4(9,7);
  for (int i=1; i<=9; i++)
    for (int j=1; j<=7; j++)
      { mtx(i,j) = 2*i+5*j;
        mtx3(i,j) = i/(1.*j);
      }
  mtx2 = &(mtx3 + mtx);
  mtx4 = &(mtx3 + mtx);
  tensor2<double> mtx5 = &(mtx+mtx3);
  if (detail) affiche ("operator = (destructive copy for temporary objects)", mtx2==mtx3+mtx && mtx4==mtx3+mtx && mtx5==mtx+mtx3);
  else result *= (mtx2==mtx3+mtx && mtx4==mtx3+mtx && mtx5==mtx+mtx3);

  tensor2<double> mtrx, mtrx2(2,3), mtrx3(12,24), mtrx4, mtrx5, mtrx6, mtrx7, mtrx8;
  mtrx = mtrx8 = mtx;
  mtrx2 &= mtrx;
  mtrx3 &= mtrx4;
  mtrx5 &= mtrx6;
  mtrx7 &= mtrx8;
  if (detail) affiche ("operator &= (destructive copy with no size check)", mtrx2==mtx && !mtrx && !mtrx3 && !mtrx5 && mtrx7==mtx && !mtrx8);
  else result *= (mtrx2==mtx && !mtrx && !mtrx3 && !mtrx5 && mtrx7==mtx && !mtrx8);

  tensor2<double> mtrx9;
  mtrx = mtrx8 = mtx;
  mtrx2 &=& mtrx;
  mtrx3 &=& (mtx+mtx);
  mtrx4 &=& mtrx;
  mtrx5  &=& mtrx6;
  mtrx9 &=& mtrx8;
  if (detail) affiche ("operator &= (destructive copy for temporary objects with no size check)", mtrx2==mtx && !mtrx && mtrx3==2.*mtx && !mtrx4 && !mtrx5 && mtrx9==mtx && !mtrx8);
  else result *= (mtrx2==mtx && !mtrx && mtrx3==2.*mtx && !mtrx4 && !mtrx5 && mtrx9==mtx && !mtrx8);

  d=a;
  d(9,9)=7;
  reel = d(9,9);
  if (detail) affiche ("operator (,)", a!=d && reel==7);
  else result *= a!=d && reel==7;

  if (detail) affiche ("dim1 dim2", nca.dim1()==9 && nca.dim2()==4);
  else result *= nca.dim1()==9 && nca.dim2()==4;

  tensor2<double> mc01(5,7);
  vector<double> vmc01(7);
  for (int i=1; i<=5; i++)
    for (int j=1; j<=7; j++)
      { mc01(i,j) = 7*i -5*j;
        vmc01[j] = 21 - 5*j;
      }
  mc01[4] = vmc01;
  vector<double> ncv(4), ncw(9);
  ncv[1] =-1; ncv[2] = 7; ncv[3]=.75;
  nca[3] = ncv;
  if (detail) affiche ("operator []", (mc01[3] == vmc01) && (mc01[3][2]==vmc01[2]) && (mc01(3,2)==vmc01[2]) && mc01[4]==vmc01 && nca[3]==ncv);
  else result *= (mc01[3] == vmc01) && (mc01[3][2]==vmc01[2]) && (mc01(3,2)==vmc01[2] && mc01[4]==vmc01 && nca[3]==ncv);

  for (int i=1; i<=9; i++)
    { e[i] = 2.*a[i];
      ncb[i] = 2.*nca[i];
    }
  if (detail) affiche ("operator +", a+a==e && nca+nca==ncb);
  else result *= (a+a==e && nca+nca==ncb);

  if (detail) affiche ("operator -", a-a==f && nca-nca==ncf);
  else result *= (a-a==f && nca-nca==ncf);

  for (int i=1; i<=9; i++)
    for (int j=1; j<=4; j++)
      { ncb(i,j) = 0;
        for (int k=1; k<=9; k++)
	  ncb(i,j) += a(i,k)*nca(k,j);
      }
  if (detail) affiche ("operator *", a*nca==ncb);
  else result *= (a*nca==ncb);

  if (detail) affiche ("operator * mat/sc", a*2.==a+a && nca*2.==nca+nca);
  else result *= (a*2.==a+a && nca*2.==nca+nca);

  if (detail) affiche ("operator * sc/mat", 2.*a==a+a && 2.*nca==nca+nca);
  else result *= (2.*a==a+a && 2.*nca==nca+nca);

  u[1]=u[9]=1.; u[2]=-2; u[3]=7; u[4]=5; u[5]=17; u[7]=-1; u[8]=0.; u[6]=2.;
  for (int i=1; i<=9; i++)
    { v[i] = a[i] * u;
      ncw[i] = nca[i] * ncv;
    }
  if (detail) affiche ("operator * mat/vect", a*u==v && nca*ncv==ncw);
  else result *= (a*u==v && nca*ncv==ncw);

  w[1]=-5; w[2]=24; w[3]=18; w[4]=27; w[5]=-13; w[6]=-1; w[7]=-11; w[8]=-10; w[9]=4;    
  for (int i=1; i<=9; i++)
    { w[i]  = 0;
      for (int j=1; j<=9; j++)
	  w[i] += a(j,i) * u[j];
    }
  for (int i=1; i<=4; i++)
    { ncv[i]  = 0;
      for (int j=1; j<=9; j++)
	  ncv[i] += nca(j,i) * ncw[j];
    }
  if (detail) affiche ("operator * vect/mat", u*a==w && ncw*nca==ncv);
  else result *= (u*a==w && ncw*nca==ncv);

  tensor2<double> matdiv(9,9);
  for (int i=1; i<=9; i++)
    for (int j=1; j<=9; j++)
      matdiv(i,j) = 2*i +2.5*j - 1 + i/j;
  if (detail) affiche ("operator / ", matdiv/matdiv==Id && cna/a==cna*(1./a));
  else result *= (matdiv/matdiv==Id && cna/a==cna*(1./a));

  if (detail) affiche ("operator / mat/sc", a/reel==a*(1/reel) && nca/reel==nca*(1/reel));
  else result *= (a/reel==a*(1/reel) && nca/reel==nca*(1/reel));

  if (detail) affiche ("operator / sc/mat", (7.5/a)*a==7.5*Id);
  else result *= ((7.5/a)*a==7.5*Id);

  double sum=0;
  for (int i=1; i<=a.Rows(); i++)
    for (int j=1; j<=a.Columns(); j++)
      sum += a(i,j) * e(i,j);
  if (detail) affiche ("operator |", (a|e)==sum);
  else result *= ((a|e)==sum);

  tensor2<float> mvv(7,5);
  mvv(1,1) = -3; mvv(2,1) = -15; mvv(3,1) = -21; mvv(4,1) = -30; mvv(5,1) = 6; mvv(6,1) = -9; mvv(7,1) = -63;
  mvv(1,3) = 5; mvv(2,3) = 25; mvv(3,3) = 35; mvv(4,3) = 50; mvv(5,3) = -10; mvv(6,3) = 15; mvv(7,3) = 105;
  mvv(1,4) = 61; mvv(2,4) = 305; mvv(3,4) = 427; mvv(4,4) = 610; mvv(5,4) = -122; mvv(6,4) = 183; mvv(7,4) = 1281;
  mvv(1,5) = 25; mvv(2,5) = 125; mvv(3,5) = 175; mvv(4,5) = 250; mvv(5,5) = -50; mvv(6,5) = 75; mvv(7,5) = 525;
  vector<float> vctv(7), vctw(5);
  vctv[1]=1; vctv[2]=5; vctv[3]=7; vctv[4]=10; vctv[5]=-2; vctv[6]=3; vctv[7]=21;
  vctw[1]=-3; vctw[3]=5; vctw[4]=61; vctw[5]=25;
  if (detail) affiche ("operator ^", mvv==(vctv^vctw));
  else result *= (mvv==(vctv^vctw));

  f=a; f+=a;
  ncc = nca; ncc+=ncb;
  if (detail) affiche ("operator +=", f==2.*a && ncc==nca+ncb);
  else result *= (f==2.*a && ncc==nca+ncb);

  f=a; f-=a;
  ncc -= ncb;
  if (detail) affiche ("operator -=", f==h && ncc==nca);
  else result *= (f==h && ncc==nca);

  f=a; f*=a;
  if (detail) affiche ("operator *= mat/mat", f==a*a);
  else result *= (f==a*a);

  f=a; f*=2.;
  ncc *= 1.23;
  if (detail) affiche ("operator *= mat/sc", f==a+a && ncc==nca*1.23);
  else result *= (f==a+a && ncc==nca*1.23);

  tensor2<double>atestgauss = a;
  atestgauss /= a;
  cna = cnb;
  cna /= a;
  if (detail) affiche ("operator /=", atestgauss==Id && cna==cnb/a);
  else result *= (atestgauss==Id && cna==cnb/a);

  tensor2<double> atest;
  atest = a;
  atest /= 4.76;
  cna = cnb;
  cna /= 4.67;
  if (detail) affiche ("operator /= mat/sc", atest==a/4.76 && cna==cnb/4.67);
  else result *= (atest==a/4.76 && cna==cnb/4.67);

  tensor2<double> amt(9,9);

  v[1]=4; v[2]=-1; v[5]=-1; v[3]=v[4]=v[6]=v[7]=v[8]=v[9]=0;
  amt[1] = v;
  v[1]=v[6]=-1; v[2]=4; v[3]=-1; v[4]=v[5]=0;
  amt[2] = v ;
  v[1]=v[5]=v[6]=0; v[2]=v[4]=v[7]=-1; v[3]=4;
  amt[3]=v;
  v[1]=v[2]=v[6]=v[7]=v[9]=0; v[4]=4; v[3]=v[5]=v[8]=-1;
  amt[4] = v ;
  v[2]=v[3]=v[7]=v[8]=0;v[1]=v[4]=v[6]=v[9]=-1; v[5]=4; 
  amt[5]=v;  
  v[1]=v[3]=v[4]=v[8]=v[9]=0; v[2]=v[5]=v[7]=-1; v[6]=4;
  amt[6]=v;
  v[1]=v[2]=v[4]=v[5]=v[9]=0; v[3]=v[6]=v[8]=-1; v[7]=4;
  amt[7]=v;
  v[1]=v[2]=v[3]=v[5]=v[6]=0; v[4]=v[7]=v[9]=-1; v[8]=4;
  amt[8]=v;
  v[1]=v[2]=v[3]=v[4]=v[6]=v[7]=0; v[5]=v[8]=-1; v[9]=4;
  amt[9]=v;
  if (detail) affiche ("det", det(amt) == 89436);
  else result *= (det(amt) == 89436);

  tensor2<float> fmt1(2,3), fmt2(3,2);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=2; j++)
      fmt1(j,i) = fmt2(i,j) = 2*i+3*j;
  f=amt; f(2,5)=7; d=amt; d(3,5) = d(5,3) = 75;
  if (detail) affiche ("t", (t(amt)==amt) && !(t(f)==f) && (t(d)==d) && t(fmt1)==fmt2 && t(ncd)==cnb);
  else result *= ((t(amt)==amt) && !(t(f)==f) && (t(d)==d) && t(fmt1)==fmt2 && t(ncd)==cnb);

  if (detail) affiche ("inv", amt.inv()*amt==Id);
  else result *= (amt.inv()*amt==Id);

  tensor2<long double> matx(3,3), matxId(3,3);
  for (int i=1; i<=3; i++) matxId(i,i) = 1;
  matx(1,1) = 4; matx(1,2) = matx(1,3) = 2;
  matx(2,1) = 4; matx(2,2) = 6; matx(2,3) = 8;
  matx(3,1) = -2; matx(3,2) = 2; matx(3,3) = 4;

  tensor2<double> aId(9,9);
  for (int i=1; i<=9; i++) aId(i,i) = 1;
  if (detail) affiche ("gauss", (matx*gauss(matx) == matxId) && (a*gauss(a) == aId));
  else result *= ((matx*gauss(matx) == matxId) && (a*gauss(a) == aId));

  ncd.save("tensor2.res");
  tensor2<double> fmat(ncd.Rows(), ncd.Columns());
  fmat.read("tensor2.res");
  if (detail) affiche("read/write", ncd==fmat);
  else result *= (ncd==fmat);

  tensor2<double> mtxinvref = mtx;
  tensor2<double> mtxinv = mtx;
  vector<double> vectinv;
  mtx.permute_rows(2,5);
  mtxinv.permute_rows(5,2);
  vectinv = mtxinvref[5];
  mtxinvref[5] = mtxinvref[2];
  mtxinvref[2] =vectinv;
  if (detail) affiche("permute_rows", mtx==mtxinvref && mtxinv==mtxinvref);
  else result *= (mtx==mtxinvref && mtxinv==mtxinvref);

  double eltinv;
  mtx.permute_columns(3,1);
  mtxinv.permute_columns(1,3);
  for (int i=1; i<=mtx.Rows(); i++)
    { eltinv = mtxinvref(i,1);
      mtxinvref(i,1) = mtxinvref(i,3);
      mtxinvref(i,3) = eltinv;
    }
  if (detail) affiche("permute_columns", mtx==mtxinvref && mtxinv==mtxinvref);
  else result *= (mtx==mtxinvref && mtxinv==mtxinvref);

  if (detail) cout << "\n--------------tests complementaires-------------- \n";
  tensor2<double> mtest(5,5);
  vector<double> vtest(5), utest(5), vbbb(5);
  tensor2<double> Id5(5,5);

  vtest[1]=2; vtest[2]=vtest[4]=vtest[5]=1;
  mtest[1]=vtest;
  vtest[1]=5; vtest[2]=2; vtest[4]=0; vtest[5]=2;
  mtest[2]=vtest;
  vtest[1]=-2; vtest[2]=3; vtest[5]=-1;
  mtest[3]=vtest;
  vtest[1]=vtest[2]=4; vtest[3]=2; vtest[5]=-7;
  mtest[4]=vtest;
  vtest[1]=1; vtest[2]=5; vtest[3]=4; vtest[5]=0;
  mtest[5]=vtest;
  vtest[1]=10; vtest[2]=7; vtest[3]=5; vtest[4]=19; vtest[5]=11;
  utest[1]=1; utest[2]=2; utest[4]=7; utest[5]=-1;
  for (int i=1; i<=5; i++) Id5(i,i) = 1;
  tensor2<double> pmatx;
  pmatx = &(gauss(mtest)*mtest);
  if (detail) affiche ("gauss", pmatx == Id5);
  else result *= (pmatx == Id5);

  if (detail) affiche("kronecker", kronecker<double>(5)==Id5);
  else result *= (kronecker<double>(5)==Id5);

  tensor2<long double> defmat1, defmat2, defmat4;
  tensor2<long double> defmat3(5,3);
  defmat1.assign(5,3);
  for (int i=1; i<=5; i++)
    for (int j=1; j<=3; j++)
      defmat1(i,j) = defmat3(i,j) = i+2*j;
  if (detail) affiche("assign", defmat1==defmat3);
  else result *= (defmat1==defmat3);

  defmat4.create(5,3);
  for (int i=1; i<=5; i++)
    defmat4[i] = defmat3[i];
  if (detail) affiche ("create", defmat4==defmat3);
  else result *= (defmat4==defmat3);

  defmat2 = defmat1;

  tensor2<double> matvv(2,2);
  tensor2<double> matabsvv(2,2);
  matvv(1,1)=0.55;matvv(1,2)=-6.458;
  matvv(2,1)=1.22;matvv(2,2)=-0.55;
  matabsvv(1,1)=0.55;matabsvv(1,2)=6.458;
  matabsvv(2,1)=1.22;matabsvv(2,2)=0.55;
  if (detail) affiche("tr", tr(matabsvv)==1.1);
  else result *= (tr(matabsvv)==1.1);

  if (detail) affiche("max", max(defmat1)==11);
  else result *= (max(defmat1)==11);

  tensor2<double> matww(10,10);
  vector<double> diag(10);
  for (int i=1; i<=10; i++)
    { for (int j=1; j<=10; j++)
	matww(i,j) = i+2*j;
      diag[i] = 3*i;
    }
  if (detail) affiche("diagonal", diagonal(matww)==diag);
  else result *= (diagonal(matww)==diag);

  tensor2<long double> spherical(3,3);
  spherical(1,1) = spherical(2,2) = spherical(3,3) = tr(matx)/3;
  if (detail) affiche("sph", sph(matx)==spherical);
  else result *= (sph(matx)==spherical);

  tensor2<long double> deviatoric =& (matx-spherical);
  if (detail) affiche("dev", dev(matx)==deviatoric && abs(tr(deviatoric))<epsilon);
  else result *= (dev(matx)==deviatoric && abs(tr(deviatoric))<epsilon);


  cout << endl;

  cout << "============================================================== \n";
  if (result) cout<< "                 2nd order tensor test passed \n";
  else cout << "                 2nd order tensor test failed \n";
  cout << "============================================================== \n";

  return result;
  
}


#endif
