/* GNU moe - My Own Editor
   Copyright (C) 2005-2023 Antonio Diaz Diaz.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

namespace Screen {

enum Keys { key_up, key_down, key_left, key_right, key_npage, key_ppage,
            key_home, key_end, key_invalid };

bool init();

int height();			// if 0, screen has not been initialized
int width();
int max_windows();

// return pointer to an array width() + 1 bytes in size
//
char * line_buf( int * const sizep );

//void beep();

const char * clock_string();

extern "C" void clock_handler( int sig );	// update the clock

int kbhit();		// Read key. Return -1 if no key is available.

/* Wait for a keystroke. Return -1 if no key is available.
   The clock only blinks when waiting here for a keystroke.
   The screen is mainly refreshed here (and in clock_handler).
   This function is the real "main loop" of the program.
*/
int wait_kbhit( const int new_clock_limit = -1, const bool get_key = true,
                const bool force_refresh = false );


/* 'history.back()' contains the default result (may be empty), and
   stores the result (if any).
   Return the size of the result string, 0 if none, -1 if aborted.
*/
long get_string( const std::string & prompt,
                 std::vector< std::string > & history,
                 const int abort_key = 3, const bool usetab = false );


void move_to( const Point & cursor );
void save_cursor( Point & cursor );
void save_lines_and_cursor( const int line, const int lines );
void restore_lines_and_cursor();

void out_buffer_line( const Buffer & buffer, Point c, const int line );
bool out_line( const std::string & s, const int line, const bool shift = false,
               const char mode = 0 );	// mode: bold, inverse, raw, underline
bool out_menu_line( const std::string & s, const int line,
                    const int hbegin = -1, const int hend = -1 );
void repaint( const Buffer * const bufp = 0 );
void show_feedback( const std::string & s );
int show_message( const std::string & s, const bool get_key = false,
                  const bool take_cursor = false, const bool discard_cc = true,
                  const bool raw = true );
void show_status_lines( const Buffer * const bufp = 0 );

Keys convert_key( const int key );
int function_key( const int key );		// return F number or -1
const char * cut_filename( const std::string & filename, const int used_size );
int user_loop( const char * const version_msg );

} // end namespace Screen
