# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import base_logic, time, sys

class liveLogic(base_logic.Base):
	"""Implements a live sourcecode editor"""
	def __init__(self, core):
		base_logic.Base.__init__(self, core)
		self.receiving = False
		self.core = core
	
	@admin
	def Call_startCode (self, context, message):
		"""Starts adding a bot modification"""
		(self.cible, self.attr, self.args) = message.strip().split(" ", 2)
		if self.args == "":
			context.say("No args given")
			return
		self.receiving = True
		self.tempfunc = "temporary_%i" % int(time.time())
		self.codeheader = "def %s (%s):\n" % (self.tempfunc, self.args)
		self.code = ""
	
	@admin
	def Call_code (self, context, message):
		"""Adds a new line to the current edited sourcecode"""
		if self.receiving:
			self.code += "\t%s\n" % message
		else:
			context.say("I won't accept code, please use startCode before sending")
	
	@admin
	def Call_endCode (self, context, message):
		"""Notice the bot that the edition is finished"""
		if not self.receiving:
			context.say("Please use startCode before endCode :p")
			return
		if self.code == "":
			context.say("Please send code before using endCode")
			return
		finalCode = self.codeheader + self.code
		codeobj = compile(finalCode, self.tempfunc + ".py", "exec")
		context.say("Code compiled")
		exec codeobj
		eval ("setattr(%s, '%s', %s)" % (self.cible, self.attr, self.tempfunc))
		context.say("Code installed")
		self.receiving = False
		self.code = ""
		self.tempfunc = ""
		self.codeheader = ""

	@admin
	def Call_dir (self, context, message):
		"""Allows you to call the python dir() function from IRC"""
		if message == "":
			context.say(str(dir()))
		else:
			try:
				context.say(eval("""dir(%s)""" % message ))
			except:
				infos = sys.exc_info()
				context.say("An exception occured")
				sys.excepthook(infos[0], infos[1], infos[2])

	@admin
	def Call_exec (self, context, message):
		"""Simply calls eval :)"""
		try:
			eval(message)
		except:
			infos = sys.exc_info()
			context.say("An exception occured")
			sys.excepthook(infos[0], infos[1], infos[2])
	
	def Call_demo (self, context, message):
		context.say("Demo")