# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import threading, time

class Context:
	"""A context is an object, associated to each bot call.
	It contains the user, the channel and the message, which were previously sent through separated arguments,
	but also a say command, the "grep" filter, it's able to say whether it's threaded or not..."""
	def __init__ (self, cmd_func, user, channel, message, bot, command_args):
		for var in ["cmd_func", "user", "channel", "message","bot", "command_args"]:
			setattr(self, var, locals()[var])
		self.grep = ""
		self.timing = False
		self.noticing = False
	
	def raw_exec (self):
		if self.timing:
			starttime = time.time()
		if self.cmd_func.func_code.co_argcount == 3:
			# A function with 3 args : self, context, message
			self.cmd_func(self, self.command_args)
		else:
			self.cmd_func(self)
		if self.timing:
			diff = time.time() - starttime
			if diff < 1:
				self.say ("%s millisecondes..." % str(diff*1000) )
			else:
				self.say ("%s secondes..." % str(diff) )
		
	def launch (self):
		if hasattr(self.cmd_func, "threaded"):
			print self.bot.threads
			try:
				assert not(self.bot.threads[self.cmd_func.func_name]._Thread__stopped)
				self.say ("Thread already launched")
			except:
				thread = threading.Thread(target=self.raw_exec)
				self.bot.threads[self.cmd_func.func_name] = thread
				thread.start()
		else:
			self.raw_exec()
	
	# This is hackish...
	# The args are reverted if you forget one arg
	def say (self, user, message = ""):
		if message == "":
			message = user
			user = ""
		if not self.grep in message:
			return
		if self.noticing:
			self.bot.notice(self.user, message)
		elif user == "":
			self.bot.say(self.channel, message)
		else:
			self.bot.say(user, message)
