(** "Registry" for running OCaml scripts.
  *
  * Copyright (C) 2003 Merjis Ltd.
  *
  * $Id: registry.mli,v 1.5 2004/09/27 12:22:54 rwmj Exp $
  *)

open Apache

exception CgiExit

val return : unit -> 'a
(** Scripts may call [return ()] at any time which immediately exits from
  * the script.  It is actually implemented by throwing [CgiExit]
  * exception which is caught (and ignored) in the registry code.
  *)

val register_script : (Request.t -> unit) -> unit
(** Scripts must call [register_script fn] once to register their main function
  * during initialization.
  *)
