(* Simple "hello, world" script.
 * Copyright (C) 2003 Merjis Ltd.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: hello.ml,v 1.2 2004/02/26 12:10:51 rwmj Exp $
 *
 * To get this working you need to locate registry.cmo and create a caml-bin
 * directory containing hello.cmo. Then set up Apache like this:
 *
 * CamlLoad /the/path/to/registry.cmo
 * Alias /caml-bin/ /path/to/your/caml-bin/
 * <Location /caml-bin>
 *   SetHandler ocaml-bytecode
 *   CamlHandler Registry.handler
 *   Options ExecCGI
 *   Allow from all
 * </Location>
 *
 * Now point your browser at /caml-bin/hello.cmo to see this script run.
 * Look for errors in the Apache error log.
 *)

open Apache
open Registry
open Cgi

(* This is the template. Normally, of course, the template should be placed in
 * an external file so that there is a clean separation of code from
 * presentation. But in this instance we include it directly in the script
 * for simplicity of installation.
 *)
let template = "
<html>
  <head><title>::title_html::</title></head>
  <body bgcolor=\"#ffffff\">
    <h1>::title_html::</h1>
    <p>
      <b>If you see this message, then everything looks like it's installed
      and working fine!</b>
    </p>
  </body>
</html>"

(* The template is compiled once when the script is loaded. *)
let template = Template.template_from_string template;;
template#set "title" "Hello, world."

let run r =
  let q = new cgi r in

  (* Display the page. *)
  q#template template

let () =
  register_script run
