(* Testing exception handling.
 * Copyright (C) 2004 Merjis Ltd.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: exceptions.ml,v 1.1 2004/09/27 11:29:55 rwmj Exp $
 *)

open Apache
open Registry
open Cgi

let run r =
  let q = new cgi r in

  let exn =
    try q#param "exception"
    with
	Not_found ->
	  StdPages.error ~title:"No exception specified"
	    q ("Must specify one of the following exception parameters: " ^
	       "exception=Not_found " ^
	       "exception=Invalid_argument " ^
	       "exception=Failure " ^
	       "exception=Exit or " ^
	       "exception=NNN where NNN is an HTTP error code such as 404");
	  raise (HttpError 500) in

  let is_digit c = c >= '0' && c <= '9' in

  let is_code str =
    String.length str = 3 &&
    is_digit str.[0] && is_digit str.[1] && is_digit str.[2]
  in

  prerr_endline ("raising exception " ^ exn);

  match exn with
      "Not_found" -> raise Not_found
    | "Invalid_argument" -> invalid_arg "testing Invalid_argument exn"
    | "Failure" -> failwith "testing Failure exn"
    | "Exit" -> raise Exit
    | str when is_code str -> raise (HttpError (int_of_string str))
    | _ -> assert false

let () =
  register_script run
