(* Worked example of a "comments page".
 * Copyright (C) 2003 Merjis Ltd.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: comments.ml,v 1.2 2004/02/26 12:10:51 rwmj Exp $
 *
 * -----
 *
 * This is a worked example of a comments 
 *)

open Apache
open Registry
open Cgi

(* This is the template. Normally, of course, the template should be placed in
 * an external file so that there is a clean separation of code from
 * presentation. But in this instance we include it directly in the script
 * for simplicity of installation.
 *)
let template = "
<html>
 <head><title>::title_html::</title></head>
  <body bgcolor=\"#ffffff\">
  <h1>::title_html::</h1>
  ::if(show_section_1)::
  <h2>Section 1</h2>
  <p>
    This is section 1. It is only shown if the section1=1 parameter is given.
  </p>
  ::end::
  ::if(show_section_2)::
  <h2>Section 2</h2>
  <p>
    This is section 2. It is only shown if the section2=1 parameter is given.
  </p>
  ::end::
  ::if(show_section_3)::
  <h2>Section 3</h2>
  <p>
    This is section 3. It is only shown if the section3=1 parameter is given.
  </p>
  ::end::
  <h2>Links</h2>
  <p>
    Try following these links:
  </p>
  <p><a href=\"?section1=1\">Show only section 1</a></p>
  <p><a href=\"?section2=1\">Show only section 2</a></p>
  <p><a href=\"?section3=1\">Show only section 3</a></p>
  <p><a href=\"?section1=1&section2=1\">Show sections 1 and 2</a></p>
  <p><a href=\"?section1=1&section3=1\">Show sections 1 and 3</a></p>
  <p><a href=\"?section1=1&section2=1&section3=1\">Show sections 1, 2 and 3</a></p>
 </body>
</html>"

(* The template is compiled once when the script is loaded. *)
let template = Template.template_from_string template;;
template#set "title" "Conditionals demonstration CGI script"

let run r =
  let q = new cgi r in

  (* Get parameters. *)
  template#conditional "show_section_1" (q#param_true "section1");
  template#conditional "show_section_2" (q#param_true "section2");
  template#conditional "show_section_3" (q#param_true "section3");

  (* Display the page. *)
  q#template template

(* Register the script's run function. *)
let () =
  register_script run
