(* Comments system.
 * Copyright (C) 2003 Merjis Ltd.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: view_comments.ml,v 1.5 2004/03/02 17:55:10 rwmj Exp $
 *
 * See examples/comments/README
 *)

open Apache
open Cgi
open Comments

(* Load and compile the template. *)
let template = get_template "view_comments.html"

let run r (q : cgi) (dbh : Dbi.connection) userid =

  let hostname = q#param "hostname" in

  (* XXX Probably possible to do the following in a single SQL statement,
   * but my SQL is not nearly good enough to navigate the maze of GROUP BYs
   * and HAVINGs ...
   *)

  (* Get the pages which contain any comments at all. *)
  let sth = dbh#prepare_cached "select distinct c.page_id, p.uri
                                  from comments as c, comments_pages as p
                                 where c.page_id = p.id
                                   and p.hostname = ?
                                 order by 2" in
  sth#execute [`String hostname];

  (* For each page, select the comments. *)
  let pages =
    sth#map
      (function [`Int pageid; `String uri] ->
	 let sth = dbh#prepare_cached
		     "select c.id,
                             c.body,
                             current_timestamp - c.posted_date,
                             u.name
                        from comments as c
                         left outer join comments_users as u on c.author = u.id
                       where c.page_id = ?
                    order by 3 desc" in
	 sth#execute [`Int pageid];

	 let comments =
	   sth#map
	     (function [`Int id; `String body; `Interval iv;
			(`Null | `String _) as name ] ->
		let name =
		  match name with
		      `Null -> "Anonymous User"
		    | `String name -> name in
		let interval = printable_interval iv in
		[ "id", Template.VarString (string_of_int id);
		  "name", Template.VarString name;
		  "interval", Template.VarString interval;
		  "body", Template.VarString body ]
		| _ -> assert false) in

	 [ "uri", Template.VarString uri;
	   "comments", Template.VarTable comments ]
	 | _ -> assert false) in

  template#table "pages" pages;

  (* Administrators are users with userid < 10. You have to hack the database
   * directly to add such users.
   *)
  template#conditional "is_administrator" (0 < userid && userid < 10);

  template#set "hostname" hostname;

  (* Display the page. *)
  q#template template

let () =
  register_script run
