(* Comments system.
 * Copyright (C) 2003 Merjis Ltd.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: post_comment.ml,v 1.7 2004/03/02 16:21:44 rwmj Exp $
 *
 * See examples/comments/README
 *)

open Apache
open Cgi
open Comments

let run r (q : cgi) dbh _ =
  (* Get parameters. *)
  let id = int_of_string (q#param "id") in
  let body = q#param "body" in
  let name = string_trim (q#param "name") in

  (* Get the URI for redirection. *)
  let sth = dbh#prepare_cached "select uri from comments_pages where id = ?" in
  sth#execute [`Int id];

  let uri = sth#fetch1string () in

  (* User exists? If not, add it. *)
  let userid =
    if name <> "" then (
      try
	let sth =
	  dbh#prepare_cached "select id from comments_users where name = ?" in
	sth#execute [`String name];
	`Int (sth#fetch1int ())
      with
	  Not_found ->
	    let sth = dbh#prepare_cached "insert into comments_users
                                          (name) values (?)" in
	    sth#execute [`String name];
	    `Int (sth#serial "comments_users_id_seq")
    ) else `Null in

  (* Don't allow an empty comment to be posted. *)
  if string_trim body = "" then
    StdPages.error q "You cannot post an empty comment."
  else (
    (* Insert the comment. *)
    let sth =
      dbh#prepare_cached "insert into comments (body, page_id, author)
                          values (?, ?, ?)" in
    sth#execute [`String body; `Int id; userid];

    dbh#commit ();

    (* Redirect back to original page. *)
    q#redirect uri
  )

let () =
  register_script run
