-- Comments system.
-- Copyright (C) 2003 Merjis Ltd.
-- 
-- This library is free software; you can redistribute it and/or
-- modify it under the terms of the GNU Library General Public
-- License as published by the Free Software Foundation; either
-- version 2 of the License, or (at your option) any later version.
--
-- This library is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
-- Library General Public License for more details.
--
-- You should have received a copy of the GNU Library General Public
-- License along with this library; if not, write to the Free
-- Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
--
-- $Id: comments_create.sql,v 1.5 2003/12/29 14:59:47 uid68240 Exp $

begin work;

create table comments_pages
(
	id serial
		constraint comments_pages_id_pk
		primary key
		constraint comments_pages_id_uq
		unique,
	hostname text
		constraint comments_pages_uri_nn
		not null,
	uri text
		constraint comments_pages_uri_nn
		not null
);

create unique index comments_pages_uq on comments_pages (hostname, uri);

create table comments_users
(
	id serial
		constraint comments_users_id_pk
		primary key
		constraint comments_users_id_uq
		unique,
	name text
		constraint comments_users_name_nn
		not null
		constraint comments_users_name_uq
		unique,
	password text
);

select setval ('comments_users_id_seq', 9);

create table comments_sessions
(
	userid int4
		constraint comments_sessions_userid_nn
		not null
		constraint comments_sessions_userid_uq
		unique
		references comments_users (id)
		on delete cascade,
	sessionid char(32)
		constraint comments_sessions_sessionid_nn
		not null
);

create table comments
(
	id serial
		constraint comments_id_pk
		primary key
		constraint comments_id_uq
		unique,
	posted_date timestamp
		default current_timestamp
		constraint comments_posted_date_nn
		not null,
	body text
		constraint comments_body_nn
		not null,
	author int4
		references comments_users (id)
		on delete set null,
	page_id int4
		constraint comments_page_id_nn
		not null
		references comments_pages (id)
		on delete cascade
);

-- Grant access to the webserver user ('www-data').

grant select, insert, update, delete on comments_pages to "www-data";
grant select, update on comments_pages_id_seq to "www-data";
grant select, insert, update, delete on comments_users to "www-data";
grant select, update on comments_users_id_seq to "www-data";
grant select, insert, update, delete on comments_sessions to "www-data";
grant select, insert, update, delete on comments to "www-data";
grant select, update on comments_id_seq to "www-data";

commit work;
