#ifndef MOBIUS_CRYPT_CIPHER_AES_H
#define MOBIUS_CRYPT_CIPHER_AES_H

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/crypt/cipher_block.h>
#include <mobius/bytearray.h>
#include <cstdint>

namespace mobius
{
namespace crypt
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief AES cipher cryptographic algorithm
//! \author Eduardo Aguiar
//! \see Advanced Encryption Standard (AES) (FIPS PUB 197)
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class cipher_aes : public cipher_block
{
public:
  explicit cipher_aes (const mobius::bytearray&, const std::string& = "ecb", const mobius::bytearray& = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0});

  void encrypt_block (mobius::bytearray&) noexcept override;
  void decrypt_block (mobius::bytearray&) noexcept override;

private:
  //! \brief number of 32-bit qwords of the key (AES-128 = 4, AES-192 = 6, AES-256 = 8)
  int nk_ = 0;

  //! \brief number of rounds (AES-128 = 10, AES-192 = 12, AES-256 = 14)
  int nr_ = 0;

  //! \brief key schedule. Size = Nb * Nr + 1. Max Nr = 14 for AES-256
  std::uint32_t w_[4 * (14 + 1)];

  //! \brief number of valid w_ values
  int nw_ = 0;
};

} // namespace crypt
} // namespace mobius

#endif
